/*
 * Decompiled with CFR 0.152.
 */
package de.raphicraft.grenzzeichen.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SpawnCommands {
    private static final String STATE_KEY = "custom_spawn";
    private static final String PREF_KEY = "custom_spawn_prefs";

    public static void register() {
        CommandRegistrationCallback.EVENT.register(SpawnCommands::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder setSpawn = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setspawn").requires(src -> src.method_9259(2))).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player == null) {
                return 0;
            }
            double x = player.method_23317();
            double y = player.method_23318();
            double z = player.method_23321();
            float yaw = player.method_36454();
            float pitch = player.method_36455();
            String worldName = player.method_37908().method_27983().method_29177().toString();
            SpawnCommands.setSpawn(((class_2168)ctx.getSource()).method_9211(), x, y, z, worldName, yaw, pitch);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Spawn set to ").method_10852((class_2561)class_2561.method_43470((String)(SpawnCommands.fmt(x) + " " + SpawnCommands.fmt(y) + " " + SpawnCommands.fmt(z))).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" facing ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, "yaw=%.1f pitch=%.1f", Float.valueOf(yaw), Float.valueOf(pitch))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" in ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)worldName).method_27692(class_124.field_1075)), true);
            return 1;
        })).then(class_2170.method_9244((String)"x", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"y", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player == null) {
                return 0;
            }
            double x = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"x");
            double y = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"y");
            double z = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"z");
            float yaw = player.method_36454();
            float pitch = player.method_36455();
            String worldName = player.method_37908().method_27983().method_29177().toString();
            SpawnCommands.setSpawn(((class_2168)ctx.getSource()).method_9211(), x, y, z, worldName, yaw, pitch);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Spawn set to ").method_10852((class_2561)class_2561.method_43470((String)(SpawnCommands.fmt(x) + " " + SpawnCommands.fmt(y) + " " + SpawnCommands.fmt(z))).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" facing ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, "yaw=%.1f pitch=%.1f", Float.valueOf(yaw), Float.valueOf(pitch))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" in ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)worldName).method_27692(class_124.field_1075)), true);
            return 1;
        }))));
        dispatcher.register(setSpawn);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resetspawn").requires(src -> src.method_9259(2))).executes(ctx -> {
            MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
            SpawnState state = SpawnCommands.getSpawnState(server);
            state.spawnX = 0.0;
            state.spawnY = 0.0;
            state.spawnZ = 0.0;
            state.spawnYaw = 0.0f;
            state.spawnPitch = 0.0f;
            state.worldName = "";
            state.method_80();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Spawn position has been reset.").method_27692(class_124.field_1061), true);
            return 1;
        }));
        SpawnCommands.registerTeleportAlias(dispatcher, "spawn");
        SpawnCommands.registerTeleportAlias(dispatcher, "hub");
        SpawnCommands.registerTeleportAlias(dispatcher, "lobby");
        SpawnCommands.registerTeleportAlias(dispatcher, "leave");
        SpawnCommands.registerTeleportAlias(dispatcher, "home");
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"spawnconfirm").then(class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> {
            b.suggest("yes");
            b.suggest("no");
            b.suggest("never");
            b.suggest("reset");
            b.suggest("status");
            return b.buildFuture();
        }).executes(ctx -> {
            String action = StringArgumentType.getString((CommandContext)ctx, (String)"action").toLowerCase(Locale.ROOT);
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player == null) {
                return 0;
            }
            switch (action) {
                case "yes": {
                    return SpawnCommands.teleportToSavedSpawn((class_2168)ctx.getSource());
                }
                case "no": {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Teleport cancelled.").method_27692(class_124.field_1080), false);
                    return 1;
                }
                case "never": {
                    SpawnCommands.setConfirmationDisabled(((class_2168)ctx.getSource()).method_9211(), player.method_5667(), true);
                    int res = SpawnCommands.teleportToSavedSpawn((class_2168)ctx.getSource());
                    if (res > 0) {
                        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"You will no longer be asked for confirmation. ").method_10852((class_2561)class_2561.method_43470((String)"Use ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"/spawnconfirm reset").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" to re-enable it.").method_27692(class_124.field_1080)), false);
                    }
                    return res;
                }
                case "reset": {
                    SpawnCommands.setConfirmationDisabled(((class_2168)ctx.getSource()).method_9211(), player.method_5667(), false);
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Spawn confirmation prompt re-enabled.").method_27692(class_124.field_1060), false);
                    return 1;
                }
                case "status": {
                    boolean disabled = SpawnCommands.isConfirmationDisabled(((class_2168)ctx.getSource()).method_9211(), player.method_5667());
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Spawn confirmation is ").method_10852((class_2561)class_2561.method_43470((String)(disabled ? "DISABLED" : "ENABLED")).method_27692(disabled ? class_124.field_1061 : class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)), false);
                    return 1;
                }
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Unknown option. Use ").method_10852((class_2561)class_2561.method_43470((String)"/spawnconfirm yes|no|never|reset|status").method_27692(class_124.field_1054)), false);
            return 0;
        })));
    }

    private static void registerTeleportAlias(CommandDispatcher<class_2168> dispatcher, String literal) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)literal).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player == null) {
                return 0;
            }
            MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
            SpawnState state = SpawnCommands.getSpawnState(server);
            if (!state.hasSpawn()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"No spawn has been set yet! Use ").method_10852((class_2561)class_2561.method_43470((String)"/setspawn").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".")), false);
                return 0;
            }
            if (SpawnCommands.isConfirmationDisabled(server, player.method_5667())) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Teleporting to spawn. ").method_10852((class_2561)class_2561.method_43470((String)"You disabled confirmations; use ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"/spawnconfirm reset").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" to turn them back on.").method_27692(class_124.field_1080)), false);
                return SpawnCommands.teleportToSavedSpawn((class_2168)ctx.getSource());
            }
            SpawnCommands.sendConfirmPrompt((class_2168)ctx.getSource());
            return 1;
        }));
    }

    private static void sendConfirmPrompt(class_2168 source) {
        class_5250 header = class_2561.method_43470((String)"\u27eb Are you sure you want to teleport to spawn?").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067});
        source.method_9226(() -> header, false);
        class_5250 yes = class_2561.method_43470((String)"[ YES ]").method_27694(s -> s.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/spawnconfirm yes")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to teleport now").method_27692(class_124.field_1060))));
        class_5250 no = class_2561.method_43470((String)"[ NO ]").method_27694(s -> s.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/spawnconfirm no")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Cancel teleport").method_27692(class_124.field_1061))));
        class_5250 never = class_2561.method_43470((String)"[ NEVER ASK AGAIN ]").method_27694(s -> s.method_10977(class_124.field_1065).method_10982(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/spawnconfirm never")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Don't ask again (re-enable with /spawnconfirm reset)").method_27692(class_124.field_1054))));
        class_5250 divider = class_2561.method_43470((String)"\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500").method_27692(class_124.field_1063);
        class_5250 line = class_2561.method_43470((String)" ").method_10852((class_2561)divider).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)yes).method_10852((class_2561)class_2561.method_43470((String)"  ")).method_10852((class_2561)no).method_10852((class_2561)class_2561.method_43470((String)"  ")).method_10852((class_2561)never).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)divider);
        source.method_9226(() -> line, false);
    }

    private static int teleportToSavedSpawn(class_2168 source) {
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        MinecraftServer server = source.method_9211();
        SpawnState state = SpawnCommands.getSpawnState(server);
        if (!state.hasSpawn()) {
            source.method_9226(() -> class_2561.method_43470((String)"No spawn has been set yet! Use ").method_10852((class_2561)class_2561.method_43470((String)"/setspawn").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".")), false);
            return 0;
        }
        class_5321<class_1937> key = state.getWorldKey();
        class_3218 targetWorld = server.method_3847(key);
        if (targetWorld == null) {
            targetWorld = server.method_30002();
            source.method_9226(() -> class_2561.method_43470((String)"Stored world not found. Teleporting to Overworld fallback.").method_27692(class_124.field_1054), false);
        }
        player.method_14251(targetWorld, state.spawnX, state.spawnY, state.spawnZ, state.spawnYaw, state.spawnPitch);
        source.method_9226(() -> class_2561.method_43470((String)"Teleported to spawn!").method_27692(class_124.field_1060), false);
        return 1;
    }

    private static void setSpawn(MinecraftServer server, double x, double y, double z, String worldName, float yaw, float pitch) {
        SpawnState state = SpawnCommands.getSpawnState(server);
        state.spawnX = x;
        state.spawnY = y;
        state.spawnZ = z;
        state.spawnYaw = yaw;
        state.spawnPitch = pitch;
        state.worldName = worldName;
        state.method_80();
    }

    private static SpawnState getSpawnState(MinecraftServer server) {
        class_26 manager = server.method_30002().method_17983();
        return (SpawnState)manager.method_17924(SpawnState::fromNbt, SpawnState::new, STATE_KEY);
    }

    private static PrefState getPrefState(MinecraftServer server) {
        class_26 manager = server.method_30002().method_17983();
        return (PrefState)manager.method_17924(PrefState::fromNbt, PrefState::new, PREF_KEY);
    }

    private static boolean isConfirmationDisabled(MinecraftServer server, UUID playerUuid) {
        return SpawnCommands.getPrefState((MinecraftServer)server).neverAsk.contains(playerUuid);
    }

    private static void setConfirmationDisabled(MinecraftServer server, UUID playerUuid, boolean disabled) {
        PrefState ps = SpawnCommands.getPrefState(server);
        if (disabled) {
            ps.neverAsk.add(playerUuid);
        } else {
            ps.neverAsk.remove(playerUuid);
        }
        ps.method_80();
    }

    private static String fmt(double d) {
        return String.format(Locale.ROOT, "%.1f", d);
    }

    private static class SpawnState
    extends class_18 {
        double spawnX = 0.0;
        double spawnY = 64.0;
        double spawnZ = 0.0;
        float spawnYaw = 0.0f;
        float spawnPitch = 0.0f;
        String worldName = "";

        private SpawnState() {
        }

        static SpawnState fromNbt(class_2487 nbt) {
            SpawnState state = new SpawnState();
            if (nbt.method_10545("world")) {
                state.spawnX = nbt.method_10574("x");
                state.spawnY = nbt.method_10574("y");
                state.spawnZ = nbt.method_10574("z");
                state.spawnYaw = nbt.method_10583("yaw");
                state.spawnPitch = nbt.method_10583("pitch");
                state.worldName = nbt.method_10558("world");
            }
            return state;
        }

        public class_2487 method_75(class_2487 nbt) {
            nbt.method_10549("x", this.spawnX);
            nbt.method_10549("y", this.spawnY);
            nbt.method_10549("z", this.spawnZ);
            nbt.method_10548("yaw", this.spawnYaw);
            nbt.method_10548("pitch", this.spawnPitch);
            nbt.method_10582("world", this.worldName);
            return nbt;
        }

        boolean hasSpawn() {
            return this.worldName != null && !this.worldName.isEmpty();
        }

        class_5321<class_1937> getWorldKey() {
            class_2960 id = new class_2960(this.worldName);
            return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
        }
    }

    private static class PrefState
    extends class_18 {
        Set<UUID> neverAsk = new HashSet<UUID>();

        private PrefState() {
        }

        static PrefState fromNbt(class_2487 nbt) {
            PrefState ps = new PrefState();
            if (nbt.method_10573("neverAsk", 9)) {
                class_2499 list = nbt.method_10554("neverAsk", 8);
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        ps.neverAsk.add(UUID.fromString(list.method_10608(i)));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return ps;
        }

        public class_2487 method_75(class_2487 nbt) {
            class_2499 list = new class_2499();
            for (UUID id : this.neverAsk) {
                list.add((Object)class_2519.method_23256((String)id.toString()));
            }
            nbt.method_10566("neverAsk", (class_2520)list);
            return nbt;
        }
    }
}

