/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.compat;

import java.util.logging.Logger;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.norevy.optileaves.config.optileavesConfig;
import net.norevy.optileaves.optileaves;

public class SodiumCompat {
    private static final Logger LOG = Logger.getLogger("OptiLeaves-Sodium");
    private static final OptionStorage<optileavesConfig> OPTION_STORAGE = SodiumCompat.createOptionStorage();

    private static OptionStorage<optileavesConfig> createOptionStorage() {
        return new OptionStorage<optileavesConfig>(){

            public optileavesConfig getData() {
                LOG.fine("Sodium requesting configuration data");
                optileaves.debugLog("Sodium requesting config data");
                return optileaves.getConfig();
            }

            public void save() {
                LOG.fine("Sodium requesting configuration save");
                optileaves.debugLog("Sodium requesting config save");
                optileaves.getConfig().save();
            }
        };
    }

    public static boolean isFancyLeaves() {
        LOG.fine("Checking Sodium leaves quality setting");
        try {
            GraphicsStatus currentGraphics = (GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_();
            boolean useFancyLeaves = SodiumClientMod.options().quality.leavesQuality.isFancy(currentGraphics);
            String qualityLevel = useFancyLeaves ? "fancy" : "fast";
            optileaves.debugLog("Sodium reports leaves quality: " + qualityLevel + " (graphics: " + String.valueOf(currentGraphics) + ")");
            return useFancyLeaves;
        }
        catch (Exception e) {
            System.err.println("[OptiLeaves] Error checking Sodium leaves quality: " + e.getMessage());
            LOG.warning("Error checking Sodium leaves quality: " + e.getMessage());
            return false;
        }
    }

    public static OptionStorage<optileavesConfig> getOptionStorage() {
        return OPTION_STORAGE;
    }
}

