/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.mixins;

import java.util.logging.Logger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.norevy.optileaves.optileaves;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Block.class})
public class BlockMixin {
    private static final Logger LOGGER = Logger.getLogger("OptiLeaves-BlockMixin");

    @Redirect(method={"shouldRenderFace"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;skipRendering(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z"))
    private static boolean shouldRenderFace(BlockState currentState, BlockState neighborState, Direction face, BlockState originalState, BlockGetter world, BlockPos blockPos, Direction renderFace) {
        try {
            boolean isLeaves = currentState.m_60734_() instanceof LeavesBlock;
            boolean optimizationEnabled = optileaves.getConfig().enabled;
            if (isLeaves && optimizationEnabled) {
                LOGGER.fine("Processing leaf block at " + String.valueOf(blockPos));
                optileaves.debugLog("Applying custom culling logic for leaves at " + String.valueOf(blockPos));
                return optileaves.shouldCullSide(world, blockPos, face);
            }
            return currentState.m_60719_(neighborState, face);
        }
        catch (Exception e) {
            System.err.println("[OptiLeaves] Error in block culling: " + e.getMessage());
            LOGGER.warning("Error in block culling: " + e.getMessage());
            return currentState.m_60719_(neighborState, face);
        }
    }
}

