/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.mixins.sodiumcompat;

import java.util.logging.Logger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.norevy.optileaves.optileaves;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(targets={"me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache"})
public class BlockOcclusionCacheMixin {
    private static final Logger LOGGER = Logger.getLogger("OptiLeaves-Sodium");

    @Redirect(method={"shouldDrawSide"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;skipRendering(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z"))
    private boolean shouldCullSide(BlockState state, BlockState adjacentState, Direction dir, BlockState originalState, BlockGetter level, BlockPos pos, Direction viewDirection) {
        try {
            boolean isLeaf = state.m_60734_() instanceof LeavesBlock;
            boolean optimizationActive = optileaves.getConfig().enabled;
            if (isLeaf && optimizationActive) {
                LOGGER.fine("Processing Sodium leaf culling at " + String.valueOf(pos) + " direction " + String.valueOf(dir));
                optileaves.debugLog("Sodium: Applying custom culling for leaves at " + String.valueOf(pos));
                return optileaves.shouldCullSide(level, pos, dir);
            }
            return state.m_60719_(adjacentState, dir);
        }
        catch (Exception e) {
            System.err.println("[OptiLeaves] Error in Sodium culling: " + e.getMessage());
            LOGGER.warning("Error in Sodium culling: " + e.getMessage());
            return state.m_60719_(adjacentState, dir);
        }
    }
}

