/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves;

import java.util.logging.Logger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.common.Mod;
import net.norevy.optileaves.compat.Compat;
import net.norevy.optileaves.config.optileavesConfig;

@Mod(value="optileaves")
public class optileaves {
    public static final String MOD_ID = "optileaves";
    private static final Logger LOG = Logger.getLogger("optileaves");

    public optileaves() {
        LOG.info("[OptiLeaves] Starting initialization...");
        System.out.println("[OptiLeaves] Initializing mod...");
        optileavesConfig config = optileaves.getConfig();
        config.load();
        System.out.println("[OptiLeaves] Configuration loaded. Enabled: " + config.enabled + ", Depth: " + config.depth);
    }

    public static optileavesConfig getConfig() {
        return optileavesConfig.INSTANCE;
    }

    public static void debugLog(String message) {
        if (optileaves.getConfig().debug) {
            System.out.println("[OptiLeaves] " + message);
        }
    }

    public static boolean shouldCullSide(BlockGetter view, BlockPos pos, Direction facing) {
        optileaves.debugLog("Checking culling for direction: " + String.valueOf(facing));
        int maxDepth = optileaves.getConfig().depth;
        if (!Compat.isFancyLeaves()) {
            optileaves.debugLog("Using fast graphics mode, depth limited to 1");
            maxDepth = 1;
        }
        boolean canCull = true;
        for (int i = 1; i <= maxDepth && canCull; ++i) {
            BlockPos targetPos = pos.m_5484_(facing, i);
            BlockState state = view.m_8055_(targetPos);
            boolean isLeaf = state != null && state.m_60734_() instanceof LeavesBlock;
            canCull = canCull && isLeaf;
        }
        return canCull;
    }
}

