/*
 * Decompiled with CFR 0.152.
 */
package cryptocraft.block;

import cryptocraft.block.entity.AsicV2BlockEntity;
import cryptocraft.procedures.OpenguiV2Procedure;
import cryptocraft.procedures.SpawnBitcoinV2Procedure;
import cryptocraft.world.inventory.GuiV2Menu;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AsicV2Block
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public AsicV2Block(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.METAL).strength(1.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).instrument(NoteBlockInstrument.BASEDRUM));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)AsicV2Block.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)6.0, (double)13.0), (VoxelShape[])new VoxelShape[]{AsicV2Block.box((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)6.0, (double)3.0), AsicV2Block.box((double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)6.0, (double)15.0), AsicV2Block.box((double)5.0, (double)6.0, (double)3.0, (double)11.0, (double)8.0, (double)12.0), AsicV2Block.box((double)5.0, (double)6.0, (double)12.0, (double)11.0, (double)7.0, (double)15.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)AsicV2Block.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)6.0, (double)13.0), (VoxelShape[])new VoxelShape[]{AsicV2Block.box((double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)6.0, (double)15.0), AsicV2Block.box((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)6.0, (double)3.0), AsicV2Block.box((double)5.0, (double)6.0, (double)4.0, (double)11.0, (double)8.0, (double)13.0), AsicV2Block.box((double)5.0, (double)6.0, (double)1.0, (double)11.0, (double)7.0, (double)4.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)AsicV2Block.box((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)6.0, (double)11.0), (VoxelShape[])new VoxelShape[]{AsicV2Block.box((double)1.0, (double)0.0, (double)5.0, (double)3.0, (double)6.0, (double)11.0), AsicV2Block.box((double)13.0, (double)0.0, (double)5.0, (double)15.0, (double)6.0, (double)11.0), AsicV2Block.box((double)3.0, (double)6.0, (double)5.0, (double)12.0, (double)8.0, (double)11.0), AsicV2Block.box((double)12.0, (double)6.0, (double)5.0, (double)15.0, (double)7.0, (double)11.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)AsicV2Block.box((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)6.0, (double)11.0), (VoxelShape[])new VoxelShape[]{AsicV2Block.box((double)13.0, (double)0.0, (double)5.0, (double)15.0, (double)6.0, (double)11.0), AsicV2Block.box((double)1.0, (double)0.0, (double)5.0, (double)3.0, (double)6.0, (double)11.0), AsicV2Block.box((double)4.0, (double)6.0, (double)5.0, (double)13.0, (double)8.0, (double)11.0), AsicV2Block.box((double)1.0, (double)6.0, (double)5.0, (double)4.0, (double)7.0, (double)11.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 20);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        SpawnBitcoinV2Procedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 20);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Asic V2");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new GuiV2Menu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        OpenguiV2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AsicV2BlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockstate, ServerLevel world, BlockPos blockpos, boolean flag) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockstate, (Level)world, (BlockPos)blockpos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof AsicV2BlockEntity) {
            AsicV2BlockEntity be = (AsicV2BlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

