/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.nightworld.mixin;

import it.crystalnest.nightworld.Constants;
import it.crystalnest.server_sided_portals.api.CustomPortalChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetherPortalBlock.class})
public abstract class NetherPortalBlockMixin
extends Block {
    private NetherPortalBlockMixin() {
        super(BlockBehaviour.Properties.of());
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRandomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && random.nextInt(500) < level.getDifficulty().getId() && CustomPortalChecker.isPortalForDimension((Level)level, (BlockPos)pos.above(), Constants.NIGHTWORLD)) {
            BlockPos bottom = pos;
            while (level.getBlockState(bottom).is((Block)this)) {
                bottom = bottom.below();
            }
            if (random.nextInt(0, 10) < 5) {
                this.handleSpawnEntity(EntityType.ZOMBIE, level, bottom);
            } else {
                this.handleSpawnEntity(EntityType.SKELETON, level, bottom);
            }
            ci.cancel();
        }
    }

    @Unique
    private <T extends EntityType<?>> void handleSpawnEntity(T entityType, ServerLevel level, BlockPos pos) {
        Entity entity;
        if (level.getBlockState(pos).isValidSpawn((BlockGetter)level, pos, entityType) && (entity = entityType.spawn(level, pos.above(), EntitySpawnReason.STRUCTURE)) != null) {
            entity.setPortalCooldown();
            Entity vehicle = entity.getVehicle();
            if (vehicle != null) {
                vehicle.setPortalCooldown();
            }
        }
    }
}

