/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.nei;

import codechicken.nei.IHandleInput;
import codechicken.nei.NEIConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import mcp.mobius.waila.gui.screens.info.ScreenEnchants;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Enchantment;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;

public final class HandlerEnchants
implements IHandleInput {
    public static final IHandleInput INSTANCE = new HandlerEnchants();

    private HandlerEnchants() {
    }

    public boolean canHandle(Class p0) {
        return true;
    }

    public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
        ItemStack stackover = gui.getStackMouseOver();
        if (stackover == null) {
            return false;
        }
        if (keyCode == NEIConfig.getKeyBinding((String)"showenchant")) {
            int itemEnchantability = stackover.getItem().getItemEnchantability();
            if (itemEnchantability == 0) {
                return false;
            }
            Minecraft mc = ModLoader.getMinecraftInstance();
            ScreenEnchants screen = new ScreenEnchants(mc.currentScreen);
            screen.setStack(stackover);
            screen.setName(DisplayUtil.itemDisplayNameShort(stackover));
            screen.setEnchantability(String.valueOf(itemEnchantability));
            for (Enchantment enchant : Enchantment.enchantmentsList) {
                boolean isCompatible = true;
                int level = 0;
                boolean isApplied = false;
                if (enchant == null || !enchant.canEnchantItem(stackover)) continue;
                if (stackover.isItemEnchanted()) {
                    Map<Integer, Integer> stackenchants = HandlerEnchants.getEnchantments(stackover);
                    for (Integer id : stackenchants.keySet()) {
                        if (!enchant.canApplyTogether(Enchantment.enchantmentsList[id])) {
                            isCompatible = false;
                        }
                        if (id != enchant.effectId) continue;
                        isApplied = true;
                        level = stackenchants.get(id);
                    }
                }
                for (int lvl = enchant.getMinLevel(); lvl <= enchant.getMaxLevel(); ++lvl) {
                    String colorcode;
                    int minEnchantEnchantability = enchant.getMinEnchantability(lvl);
                    int maxEnchantEnchantability = enchant.getMaxEnchantability(lvl);
                    boolean minItemEnchantability = true;
                    int maxItemEnchantability = 1 + itemEnchantability / 2;
                    int minModifiedEnchantability = (int)(0.85 * (double)minItemEnchantability + 0.5);
                    int maxModifiedEnchantability = (int)(1.15 * (double)maxItemEnchantability + 0.5);
                    int minLevel = (int)((double)(minEnchantEnchantability - minModifiedEnchantability) / 1.15);
                    int maxLevel = (int)((double)(maxEnchantEnchantability - maxModifiedEnchantability) / 0.85);
                    String string = colorcode = isCompatible ? "\u00a7f" : "\u00a7c";
                    if (isApplied && lvl == level) {
                        colorcode = "\u00a7e";
                    }
                    screen.addRow(colorcode + enchant.getTranslatedName(lvl), colorcode + minLevel, colorcode + maxLevel, colorcode + enchant.getWeight(), "\u00a79\u00a7o" + ModIdentification.identifyMod(enchant));
                }
            }
            mc.displayGuiScreen((GuiScreen)screen);
        }
        return false;
    }

    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        return false;
    }

    public static Map<Integer, Integer> getEnchantments(ItemStack stack) {
        LinkedHashMap<Integer, Integer> ret = new LinkedHashMap<Integer, Integer>();
        NBTTagList list = stack.getEnchantmentTagList();
        if (list != null) {
            for (int i = 0; i < list.tagCount(); ++i) {
                short var4 = ((NBTTagCompound)list.tagAt(i)).getShort("id");
                short var5 = ((NBTTagCompound)list.tagAt(i)).getShort("lvl");
                ret.put(Integer.valueOf(var4), Integer.valueOf(var5));
            }
        }
        return ret;
    }
}

