/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mcp.mobius.waila.api.IBlockDecorator;
import mcp.mobius.waila.api.ICropProvider;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.impl.PluginConfig;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.mod_BlockHelper;

public class WailaRegistrar
implements IRegistrar {
    private static WailaRegistrar instance = null;
    public final Map<Class<?>, List<IDataProvider>> headBlockProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IDataProvider>> bodyBlockProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IDataProvider>> tailBlockProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IDataProvider>> stackBlockProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IDataProvider>> NBTDataProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IBlockDecorator>> blockClassDecorators = new LinkedHashMap();
    public final Map<Class<?>, List<IEntityProvider>> headEntityProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IEntityProvider>> bodyEntityProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IEntityProvider>> tailEntityProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IEntityProvider>> overrideEntityProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IEntityProvider>> stackEntityProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IEntityProvider>> NBTEntityProviders = new LinkedHashMap();
    public final Map<Class<?>, List<ICropProvider>> cropProviders = new LinkedHashMap();
    public final Map<String, ITooltipRenderer> tooltipRenderers = new LinkedHashMap<String, ITooltipRenderer>();

    private WailaRegistrar() {
        instance = this;
    }

    public static WailaRegistrar instance() {
        return instance == null ? new WailaRegistrar() : instance;
    }

    @Override
    public void addConfig(String modName, String key, String translationKey) {
        this.addConfig(modName, key, translationKey, true);
    }

    @Override
    public void addSyncedConfig(String modName, String key, String translationKey) {
        this.addSyncedConfig(modName, key, translationKey, true);
    }

    @Override
    public void addConfig(String modName, String key) {
        this.addConfig(modName, key, true);
    }

    @Override
    public void addSyncedConfig(String modName, String key) {
        this.addSyncedConfig(modName, key, true);
    }

    @Override
    public void addConfig(String modName, String key, boolean defValue) {
        this.addConfig(modName, key, "option." + key, defValue);
    }

    @Override
    public void addSyncedConfig(String modName, String key, boolean defValue) {
        this.addSyncedConfig(modName, key, "option." + key, defValue);
    }

    @Override
    public void addConfig(String modName, String key, String translationKey, boolean defValue) {
        PluginConfig.instance().addConfig(modName, key, translationKey, defValue);
    }

    @Override
    public void addSyncedConfig(String modName, String key, String translationKey, boolean defValue) {
        PluginConfig.instance().addSyncedConfig(modName, key, translationKey, defValue);
    }

    @Override
    public void registerHeadProvider(IDataProvider dataProvider, Class<?> block) {
        this.registerProvider(dataProvider, block, this.headBlockProviders);
    }

    @Override
    public void registerBodyProvider(IDataProvider dataProvider, Class<?> block) {
        this.registerProvider(dataProvider, block, this.bodyBlockProviders);
    }

    @Override
    public void registerTailProvider(IDataProvider dataProvider, Class<?> block) {
        this.registerProvider(dataProvider, block, this.tailBlockProviders);
    }

    @Override
    public void registerStackProvider(IDataProvider dataProvider, Class<?> block) {
        this.registerProvider(dataProvider, block, this.stackBlockProviders);
    }

    @Override
    public void registerNBTProvider(IDataProvider dataProvider, Class<?> block) {
        this.registerProvider(dataProvider, block, this.NBTDataProviders);
    }

    @Override
    public void registerHeadProvider(IEntityProvider dataProvider, Class<?> entity) {
        this.registerProvider(dataProvider, entity, this.headEntityProviders);
    }

    @Override
    public void registerBodyProvider(IEntityProvider dataProvider, Class<?> entity) {
        this.registerProvider(dataProvider, entity, this.bodyEntityProviders);
    }

    @Override
    public void registerTailProvider(IEntityProvider dataProvider, Class<?> entity) {
        this.registerProvider(dataProvider, entity, this.tailEntityProviders);
    }

    @Override
    public void registerStackProvider(IEntityProvider dataProvider, Class<?> entity) {
        this.registerProvider(dataProvider, entity, this.stackEntityProviders);
    }

    @Override
    public void registerNBTProvider(IEntityProvider dataProvider, Class<?> entity) {
        this.registerProvider(dataProvider, entity, this.NBTEntityProviders);
    }

    @Override
    public void registerOverrideEntityProvider(IEntityProvider dataProvider, Class<?> entity) {
        this.registerProvider(dataProvider, entity, this.overrideEntityProviders);
    }

    @Override
    public void registerDecorator(IBlockDecorator decorator, Class<?> block) {
        this.registerProvider(decorator, block, this.blockClassDecorators);
    }

    @Override
    public void registerCropProvider(ICropProvider cropProvider, Class<?> block) {
        this.registerProvider(cropProvider, block, this.cropProviders);
    }

    private <T, V> void registerProvider(T dataProvider, V clazz, Map<V, List<T>> target) {
        List<T> providers;
        if (clazz == null || dataProvider == null) {
            throw new RuntimeException(String.format("Trying to register a null provider or null block! Please check the stacktrace to know what was the original registration method. [Provider: %s, Target: %s]", dataProvider == null ? "null" : dataProvider.getClass().getName(), clazz));
        }
        if (!target.containsKey(clazz)) {
            target.put(clazz, (List<T>)new ArrayList());
        }
        if (!(providers = target.get(clazz)).contains(dataProvider)) {
            target.get(clazz).add(dataProvider);
        }
    }

    @Override
    public void registerTooltipRenderer(String name, ITooltipRenderer renderer) {
        if (!this.tooltipRenderers.containsKey(name)) {
            this.tooltipRenderers.put(name, renderer);
        } else {
            mod_BlockHelper.LOG.warning(String.format("A renderer named %s already exists (Class: %s). Skipping new renderer.", name, renderer.getClass().getName()));
        }
    }

    public Map<Integer, List<IDataProvider>> getHeadProviders(Object block) {
        return this.getProviders(block, this.headBlockProviders);
    }

    public Map<Integer, List<IDataProvider>> getBodyProviders(Object block) {
        return this.getProviders(block, this.bodyBlockProviders);
    }

    public Map<Integer, List<IDataProvider>> getTailProviders(Object block) {
        return this.getProviders(block, this.tailBlockProviders);
    }

    public Map<Integer, List<IDataProvider>> getStackProviders(Object block) {
        return this.getProviders(block, this.stackBlockProviders);
    }

    public Map<Integer, List<IDataProvider>> getNBTProviders(Object block) {
        return this.getProviders(block, this.NBTDataProviders);
    }

    public Map<Integer, List<IEntityProvider>> getHeadEntityProviders(Object entity) {
        return this.getProviders(entity, this.headEntityProviders);
    }

    public Map<Integer, List<IEntityProvider>> getBodyEntityProviders(Object entity) {
        return this.getProviders(entity, this.bodyEntityProviders);
    }

    public Map<Integer, List<IEntityProvider>> getTailEntityProviders(Object entity) {
        return this.getProviders(entity, this.tailEntityProviders);
    }

    public Map<Integer, List<IEntityProvider>> getOverrideEntityProviders(Object entity) {
        return this.getProviders(entity, this.overrideEntityProviders);
    }

    public Map<Integer, List<IEntityProvider>> getStackEntityProviders(Object entity) {
        return this.getProviders(entity, this.stackEntityProviders);
    }

    public Map<Integer, List<IEntityProvider>> getNBTEntityProviders(Object entity) {
        return this.getProviders(entity, this.NBTEntityProviders);
    }

    public Map<Integer, List<IBlockDecorator>> getBlockDecorators(Object block) {
        return this.getProviders(block, this.blockClassDecorators);
    }

    public Map<Integer, List<ICropProvider>> getCropProviders(Object block) {
        return this.getProviders(block, this.cropProviders);
    }

    public ITooltipRenderer getTooltipRenderer(String name) {
        return this.tooltipRenderers.get(name);
    }

    private <V, T> Map<Integer, List<T>> getProviders(V obj, Map<Class<? extends V>, List<T>> target) {
        TreeMap<Integer, List<T>> returnList = new TreeMap<Integer, List<T>>();
        int index = 0;
        for (Class<V> clazz : target.keySet()) {
            if (clazz.isInstance(obj)) {
                returnList.put(index, target.get(clazz));
            }
            ++index;
        }
        return returnList;
    }

    public boolean hasStackProviders(Object block) {
        return this.hasProviders(block, this.stackBlockProviders);
    }

    public boolean hasHeadProviders(Object block) {
        return this.hasProviders(block, this.headBlockProviders);
    }

    public boolean hasBodyProviders(Object block) {
        return this.hasProviders(block, this.bodyBlockProviders);
    }

    public boolean hasTailProviders(Object block) {
        return this.hasProviders(block, this.tailBlockProviders);
    }

    public boolean hasNBTProviders(Object block) {
        return this.hasProviders(block, this.NBTDataProviders);
    }

    public boolean hasStackEntityProviders(Entity entity) {
        return this.hasProviders(entity, this.stackEntityProviders);
    }

    public boolean hasHeadEntityProviders(Entity entity) {
        return this.hasProviders(entity, this.headEntityProviders);
    }

    public boolean hasBodyEntityProviders(Entity entity) {
        return this.hasProviders(entity, this.bodyEntityProviders);
    }

    public boolean hasTailEntityProviders(Entity entity) {
        return this.hasProviders(entity, this.tailEntityProviders);
    }

    public boolean hasOverrideEntityProviders(Entity entity) {
        return this.hasProviders(entity, this.overrideEntityProviders);
    }

    public boolean hasNBTEntityProviders(Entity entity) {
        return this.hasProviders(entity, this.NBTEntityProviders);
    }

    public boolean hasBlockDecorator(Block block) {
        return this.hasProviders(block, this.blockClassDecorators);
    }

    public boolean hasCropProvider(Object block) {
        return this.hasProviders(block, this.cropProviders);
    }

    private <V, T> boolean hasProviders(Object obj, Map<Class<? extends V>, List<T>> target) {
        for (Class<V> clazz : target.keySet()) {
            if (!clazz.isInstance(obj)) continue;
            return true;
        }
        return false;
    }
}

