/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import forge.Configuration;
import forge.ForgeHooksClient;
import forge.IConnectionHandler;
import forge.MinecraftForge;
import forge.NetworkMod;
import java.io.File;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.client.ConfigKeyHandler;
import mcp.mobius.waila.network.WailaConnectionHandler;
import mcp.mobius.waila.overlay.DecoratorRenderer;
import mcp.mobius.waila.overlay.NEIOverlayRenderer;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.overlay.WailaTickHandler;
import mcp.mobius.waila.proxy.ProxyClient;
import mcp.mobius.waila.proxy.ProxyCommon;
import mcp.mobius.waila.utils.BlockHelperUpdater;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.log.FMLLikeLogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.ModLoader;
import net.minecraft.src.World;
import net.minecraft.src.WorldClient;

public class mod_BlockHelper
extends NetworkMod {
    public static final String PACKAGE = "mcp.mobius.waila.";
    public static final String MOD_ID = "mod_BlockHelper";
    public static final String NAME = "Block Helper";
    public static final String VERSION = "2.0.0-pre6";
    public static final String MC_VERSION = "1.2.5";
    public static final String CHANNEL = "BlockHelper";
    public static final String CHANNEL_SSP = "BlockHelperSSP";
    public static final Logger LOG = Logger.getLogger("Block Helper");
    public static final BlockHelperUpdater UPDATER = new BlockHelperUpdater();
    public static mod_BlockHelper INSTANCE;
    public static ProxyCommon proxy;
    public static boolean DEV_MODE;
    private WailaTickHandler tickHandler;
    private ConfigKeyHandler configKeyHandler;
    public boolean serverPresent = false;

    public static String getModId() {
        return MOD_ID;
    }

    public String getName() {
        return NAME;
    }

    public String getVersion() {
        return VERSION;
    }

    public void load() {
        INSTANCE = this;
        proxy = new ProxyClient();
        I18n.INSTANCE.addLangDirFromHost(mod_BlockHelper.class, "/assets/waila/lang");
        new Thread((Runnable)UPDATER, "Block Helper Version Check").start();
        Configuration cfg = new Configuration(new File(Minecraft.getMinecraftDir(), "config/BlockHelper.cfg"));
        PluginConfig.instance().loadDefaultConfig(cfg);
        OverlayConfig.updateColors();
        ForgeHooksClient.renderWorldLastHandlers.add(new DecoratorRenderer());
        ForgeHooksClient.renderWorldLastHandlers.add(new NEIOverlayRenderer());
        this.configKeyHandler = new ConfigKeyHandler(this);
        this.tickHandler = new WailaTickHandler();
        MinecraftForge.registerConnectionHandler((IConnectionHandler)new WailaConnectionHandler());
        proxy.prepare();
        proxy.registerCorePlugins(WailaRegistrar.instance());
    }

    public void modsLoaded() {
        proxy.registerModPlugins(WailaRegistrar.instance());
        proxy.postLoad();
    }

    public boolean onTickInGame(float time, Minecraft mc) {
        this.configKeyHandler.onTickInGame(mc);
        this.tickHandler.onTickInGame(mc);
        return true;
    }

    public boolean onTickInGUI(float tick, Minecraft mc, GuiScreen gui) {
        this.tickHandler.onTickInGUI(mc, gui);
        return true;
    }

    public static void registerPlugin(IWailaPlugin plugin) {
        proxy.registerPlugin(plugin);
    }

    static {
        DEV_MODE = false;
        LOG.setParent(ModLoader.getLogger());
        ConsoleHandler ch = new ConsoleHandler();
        LOG.setUseParentHandlers(false);
        LOG.addHandler(ch);
        ch.setFormatter(new FMLLikeLogFormatter());
    }

    public static class Accessor {
        public static int damageDropped(Block b, int meta) {
            return b.damageDropped(meta);
        }

        public static Entity getEntityByID(World w, int entityId) {
            if (w == null) {
                return null;
            }
            try {
                Entity e;
                if (w instanceof WorldClient && (e = ((WorldClient)w).getEntityByID(entityId)) != null) {
                    return e;
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            List list = w.getLoadedEntityList();
            if (list != null) {
                for (Entity e : list) {
                    if (e.entityId != entityId) continue;
                    return e;
                }
            }
            return null;
        }
    }
}

