/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mcp.mobius.waila.network.IWailaPacket;
import mcp.mobius.waila.network.Packet0x00ServerPing;
import mcp.mobius.waila.network.Packet0x01TileRequest;
import mcp.mobius.waila.network.Packet0x02EntRequest;
import mcp.mobius.waila.network.Packet0x03NBTData;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet250CustomPayload;

public class WailaPacketHandler {
    public static final WailaPacketHandler INSTANCE = new WailaPacketHandler();

    private WailaPacketHandler() {
    }

    public void onPacketData(EntityPlayer source, Packet250CustomPayload payload) {
        try {
            if (!payload.tag.equals("BlockHelper")) {
                return;
            }
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(payload.data));
            byte header = WailaPacketHandler.getHeader(inputStream);
            IWailaPacket castedPacket = WailaPacketHandler.getWailaPacket(header);
            if (castedPacket != null) {
                castedPacket.decode(inputStream);
                castedPacket.handleServer(source);
            }
            inputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte getHeader(DataInputStream inputStream) {
        try {
            return inputStream.readByte();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static IWailaPacket getWailaPacket(byte header) {
        if (header == 0) {
            return new Packet0x00ServerPing();
        }
        if (header == 1) {
            return new Packet0x01TileRequest();
        }
        if (header == 2) {
            return new Packet0x02EntRequest();
        }
        if (header == 3) {
            return new Packet0x03NBTData();
        }
        return null;
    }

    public static byte getPacketId(IWailaPacket packet) {
        if (packet instanceof Packet0x00ServerPing) {
            return 0;
        }
        if (packet instanceof Packet0x01TileRequest) {
            return 1;
        }
        if (packet instanceof Packet0x02EntRequest) {
            return 2;
        }
        if (packet instanceof Packet0x03NBTData) {
            return 3;
        }
        return -1;
    }

    public static Packet250CustomPayload wrapMLPacket(IWailaPacket packet) {
        Packet250CustomPayload mlPacket = new Packet250CustomPayload();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeByte(WailaPacketHandler.getPacketId(packet));
            packet.encode(outputStream);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, packet.getClass());
        }
        mlPacket.tag = "BlockHelper";
        mlPacket.data = bos.toByteArray();
        mlPacket.length = bos.size();
        return mlPacket;
    }

    public static void sendPacketToPlayer(IWailaPacket packet, EntityPlayer player) {
        player.netServerHandler.sendPacket((Packet)WailaPacketHandler.wrapMLPacket(packet));
    }
}

