/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.bc3;

import mcp.mobius.waila.addons.bc3.BC3Plugin;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public final class HUDHandlerBC3Energy
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerBC3Energy();

    private HUDHandlerBC3Energy() {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            Object prov;
            Float energy = Float.valueOf(-1.0f);
            Integer maxsto = -1;
            if (BC3Plugin.TileEngine.isInstance(te)) {
                Object engine = BC3Plugin.TileEngine_engine.get(te);
                if (engine != null) {
                    energy = Float.valueOf(BC3Plugin.Engine_energy.getFloat(engine));
                    maxsto = BC3Plugin.Engine_maxEnergy.getInt(engine);
                }
            } else if (BC3Plugin.IPowerReceptor.isInstance(te) && (prov = BC3Plugin.IPowerReceptor_getPowerProvider.invoke((Object)te, new Object[0])) != null) {
                energy = (Float)BC3Plugin.IPowerProvider_getEnergyStored.invoke(prov, new Object[0]);
                maxsto = (Integer)BC3Plugin.IPowerProvider_getMaxEnergyStored.invoke(prov, new Object[0]);
            }
            tag.setInteger("MJEnergy", Math.round(energy.floatValue()));
            tag.setInteger("MJMaxStorage", maxsto.intValue());
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass());
        }
    }
}

