/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.appeng;

import mcp.mobius.waila.addons.appeng.AppEngPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class HUDAppEngMonitor
implements IDataProvider {
    public static final HUDAppEngMonitor INSTANCE = new HUDAppEngMonitor();

    private HUDAppEngMonitor() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        try {
            if (config.get("appeng.monitorcontent") && accessor.getNBTData().hasKey("AppEngMonitor_Item")) {
                NBTTagCompound nbt = accessor.getNBTData().getCompoundTag("AppEngMonitor_Item");
                ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt);
                currenttip.add(I18n.translate("hud.msg.item", new Object[0]) + ": " + "\u00a4\u00a4a" + "\u00a7f" + DisplayUtil.itemDisplayNameShort(stack));
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            ItemStack stack;
            if (AppEngPlugin.TileStorageMonitor.isInstance(te) && (stack = (ItemStack)AppEngPlugin.TileStorageMonitor_getItem.invoke((Object)te, new Object[0])) != null) {
                NBTTagCompound stackTag = new NBTTagCompound();
                stack.writeToNBT(stackTag);
                tag.setCompoundTag("AppEngMonitor_Item", stackTag);
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

