/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic2;

import mcp.mobius.waila.addons.ic2.IC2Plugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class HUDHandlerIC2IEnergySink
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerIC2IEnergySink();

    private HUDHandlerIC2IEnergySink() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get("ic2.inputeumach") || config.get("ic2.inputeuother")) {
            try {
                int in = accessor.getNBTInteger("maxInput");
                String inputStr = I18n.translate("hud.msg.input", new Object[0]);
                if (in > 0) {
                    currenttip.add(inputStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + in + "\u00a7r" + " EU/t");
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
            }
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            int in = -1;
            if (IC2Plugin.IEnergySink.isInstance(te)) {
                in = (Integer)IC2Plugin.IEnergySink_getInput.invoke((Object)te, new Object[0]);
            }
            tag.setInteger("maxInput", in);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

