/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.forge.IContainerInputHandler;
import java.lang.reflect.Method;
import java.util.Map;
import mcp.mobius.waila.gui.screens.info.ScreenEnchants;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.AccessHelper;
import mcp.mobius.waila.utils.ModIdentification;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class HandlerEnchants
implements IContainerInputHandler {
    public static final IContainerInputHandler INSTANCE = new HandlerEnchants();
    private static final Method canApplyAtEnchantingTable;

    private HandlerEnchants() {
    }

    public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
        return false;
    }

    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        GuiContainerManager manager = gui.manager;
        ItemStack stackover = manager.getStackMouseOver();
        if (stackover == null) {
            return false;
        }
        if (keyID == NEIClientConfig.getKeyBinding((String)"showenchant")) {
            int itemEnchantability = stackover.getItem().getItemEnchantability();
            if (itemEnchantability == 0) {
                return false;
            }
            Minecraft mc = Minecraft.getMinecraft();
            ScreenEnchants screen = new ScreenEnchants(mc.currentScreen);
            screen.setStack(stackover);
            screen.setName(DisplayUtil.itemDisplayNameShort(stackover));
            screen.setEnchantability(String.valueOf(itemEnchantability));
            Enchantment[] enchants = stackover.getItem() == Item.book ? Enchantment.field_92090_c : Enchantment.enchantmentsList;
            for (Enchantment enchant : enchants) {
                boolean isCompatible = true;
                int level = 0;
                boolean isApplied = false;
                if (enchant == null) continue;
                boolean canApplyAtET = false;
                try {
                    canApplyAtET = (Boolean)canApplyAtEnchantingTable.invoke((Object)enchant, stackover);
                }
                catch (Throwable t) {
                    WailaExceptionHandler.handleErr(t, enchant.getClass(), null);
                }
                if (!canApplyAtET && stackover.getItem() != Item.book) continue;
                if (stackover.isItemEnchanted()) {
                    Map stackenchants = EnchantmentHelper.getEnchantments((ItemStack)stackover);
                    for (Integer id : stackenchants.keySet()) {
                        if (!enchant.canApplyTogether(Enchantment.enchantmentsList[id])) {
                            isCompatible = false;
                        }
                        if (id != enchant.effectId) continue;
                        isApplied = true;
                        level = (Integer)stackenchants.get(id);
                    }
                }
                for (int lvl = enchant.getMinLevel(); lvl <= enchant.getMaxLevel(); ++lvl) {
                    String colorcode;
                    int minEnchantEnchantability = enchant.getMinEnchantability(lvl);
                    int maxEnchantEnchantability = enchant.getMaxEnchantability(lvl);
                    boolean minItemEnchantability = true;
                    int maxItemEnchantability = 1 + itemEnchantability / 2;
                    int minModifiedEnchantability = (int)(0.85 * (double)minItemEnchantability + 0.5);
                    int maxModifiedEnchantability = (int)(1.15 * (double)maxItemEnchantability + 0.5);
                    int minLevel = (int)((double)(minEnchantEnchantability - minModifiedEnchantability) / 1.15);
                    int maxLevel = (int)((double)(maxEnchantEnchantability - maxModifiedEnchantability) / 0.85);
                    String string = colorcode = isCompatible ? "\u00a7f" : "\u00a7c";
                    if (isApplied && lvl == level) {
                        colorcode = "\u00a7e";
                    }
                    screen.addRow(colorcode + enchant.getTranslatedName(lvl), colorcode + minLevel, colorcode + maxLevel, colorcode + enchant.getWeight(), "\u00a79\u00a7o" + ModIdentification.nameFromObject(enchant));
                }
            }
            mc.displayGuiScreen((GuiScreen)screen);
        }
        return false;
    }

    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        return false;
    }

    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
    }

    public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
    }

    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        return false;
    }

    public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
    }

    public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
    }

    static {
        try {
            canApplyAtEnchantingTable = AccessHelper.getMethod(Enchantment.class, new Class[]{ItemStack.class}, "canApplyAtEnchantingTable", "func_92037_a", "func_92089_a", "a");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

