/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.appeng;

import mcp.mobius.waila.addons.appeng.AppEngPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerMEPowerStorage
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerMEPowerStorage();

    private HUDHandlerMEPowerStorage() {
    }

    @Override
    public ur getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(ur itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ur itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        try {
            int storage = accessor.getNBTInteger("AEStorage");
            int maxStorage = accessor.getNBTInteger("AEMaxStorage");
            String storedStr = I18n.translate("hud.msg.stored", new Object[0]);
            if (config.get("appeng.storage") && maxStorage > 0) {
                currenttip.add(storedStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(storage, maxStorage) + "\u00a7r" + " / " + "\u00a7f" + maxStorage + "\u00a7r" + " AE");
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(ur itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(any te, bq tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            float storage = -1.0f;
            float maxStorage = -1.0f;
            if (AppEngPlugin.TilePoweredBase.isInstance(te)) {
                storage = AppEngPlugin.TilePoweredBase_storedPower.getFloat(te);
                maxStorage = AppEngPlugin.TilePoweredBase_maxStoredPower.getFloat(te);
            }
            tag.a("AEStorage", Math.round(storage));
            tag.a("AEMaxStorage", Math.round(maxStorage));
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

