/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import forge.IRenderWorldLastHandler;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.utils.SpawnUtil;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Chunk;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class NEIOverlayRenderer
implements IRenderWorldLastHandler {
    public static int renderChunkBounds = 0;
    public static boolean renderMobSpawnOverlay = false;

    public void onRenderWorldLast(RenderGlobal renderer, float partialTicks) {
        GL11.glPushMatrix();
        EntityLiving entity = renderer.mc.renderViewEntity;
        double interpPosX = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)partialTicks;
        double interpPosY = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)partialTicks;
        double interpPosZ = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)partialTicks;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
        NEIOverlayRenderer.renderChunkBounds((Entity)entity);
        NEIOverlayRenderer.renderMobSpawnOverlay((Entity)entity);
        GL11.glPopMatrix();
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : Math.min(value, max);
    }

    private static void renderMobSpawnOverlay(Entity entity) {
        if (!renderMobSpawnOverlay) {
            return;
        }
        boolean oldOverlay = PluginConfig.instance().get("general.oldlightlevelol");
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        byte curSpawnMode = 2;
        World world = entity.worldObj;
        int x1 = (int)entity.posX;
        int z1 = (int)entity.posZ;
        int y1 = (int)NEIOverlayRenderer.clamp(entity.posY, 16.0, world.func_35452_b() - 16);
        AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        for (int x2 = x1 - 16; x2 <= x1 + 16; ++x2) {
            for (int z2 = z1 - 16; z2 <= z1 + 16; ++z2) {
                Chunk chunk = world.getChunkFromBlockCoords(x2, z2);
                BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(x2, z2);
                if (biome.getSpawnableList(EnumCreatureType.monster).isEmpty() || !(biome.getSpawningChance() > 0.0f)) continue;
                for (int y2 = y1 - 16; y2 < y1 + 16; ++y2) {
                    byte spawnMode = SpawnUtil.getSpawnMode(chunk, aabb, x2, y2, z2);
                    if (spawnMode == 0) continue;
                    if (spawnMode != curSpawnMode) {
                        if (spawnMode == 2 || oldOverlay) {
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                        }
                        curSpawnMode = spawnMode;
                    }
                    GL11.glVertex3d((double)x2, (double)((double)y2 + 0.004), (double)z2);
                    GL11.glVertex3d((double)(x2 + 1), (double)((double)y2 + 0.004), (double)(z2 + 1));
                    GL11.glVertex3d((double)(x2 + 1), (double)((double)y2 + 0.004), (double)z2);
                    GL11.glVertex3d((double)x2, (double)((double)y2 + 0.004), (double)(z2 + 1));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static void renderChunkBounds(Entity entity) {
        if (renderChunkBounds == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        for (int cx = -4; cx <= 4; ++cx) {
            for (int cz = -4; cz <= 4; ++cz) {
                double x1 = entity.chunkCoordX + cx << 4;
                double z1 = entity.chunkCoordZ + cz << 4;
                double x2 = x1 + 16.0;
                double z2 = z1 + 16.0;
                double dy = 128.0;
                double y1 = Math.floor(entity.posY - dy / 2.0);
                double y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.worldObj.func_35452_b()) {
                    y2 = entity.worldObj.func_35452_b();
                    y1 = y2 - dy;
                }
                double dist = Math.pow(1.5, -(cx * cx + cz * cz));
                GL11.glColor4d((double)0.9, (double)0.0, (double)0.0, (double)dist);
                if (cx >= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z2);
                }
                if (cx >= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z1);
                }
                if (cx <= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z2);
                }
                if (cx <= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z1);
                }
                if (renderChunkBounds != 2 || cx != 0 || cz != 0) continue;
                dy = 32.0;
                y1 = Math.floor(entity.posY - dy / 2.0);
                y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.worldObj.func_35452_b()) {
                    y2 = entity.worldObj.func_35452_b();
                    y1 = y2 - dy;
                }
                GL11.glColor4d((double)0.0, (double)0.9, (double)0.0, (double)0.4);
                for (double y3 = (double)((int)y1); y3 <= y2; y3 += 1.0) {
                    GL11.glVertex3d((double)x2, (double)y3, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y3, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y3, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y3, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y3, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y3, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y3, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y3, (double)z1);
                }
                for (double h = 1.0; h <= 15.0; h += 1.0) {
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z2);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x1, (double)y2, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y2, (double)(z1 + h));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

