/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerEntityAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.I18n;
import net.minecraft.src.Block;
import net.minecraft.src.BlockCloth;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntityTNTPrimed;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;

public final class HUDHandlerEntities
implements IEntityProvider {
    public static final IEntityProvider INSTANCE = new HUDHandlerEntities();
    public static int nhearts = 20;
    public static float maxhpfortext = 40.0f;

    private HUDHandlerEntities() {
    }

    @Override
    public Entity getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public ItemStack getDisplayItem(IEntityAccessor accessor, IPluginConfig config) {
        if (accessor.getEntity() instanceof EntityTNTPrimed) {
            return new ItemStack(Block.tnt);
        }
        return null;
    }

    @Override
    public void modifyHead(Entity entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        if (entity instanceof EntityPlayer) {
            currenttip.set(0, "\u00a7f" + ((EntityPlayer)entity).username);
        }
    }

    @Override
    public void modifyBody(Entity entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.get("vanilla.showhp") && entity instanceof EntityLiving) {
            nhearts = nhearts <= 0 ? 20 : nhearts;
            NBTTagCompound tag = accessor.getNBTData();
            float health = accessor.getNBTInteger(tag, "Health");
            float healthHearts = health / 2.0f;
            if (health > maxhpfortext) {
                currenttip.add(String.format("%.0f \u2764", Float.valueOf(health)));
            } else {
                currenttip.add(SpecialChars.getRenderString("waila.health", nhearts, Float.valueOf(healthHearts), Float.valueOf(healthHearts)));
            }
        }
        if (config.get("vanilla.sheep") && entity instanceof EntitySheep) {
            currenttip.add(I18n.translate("hud.msg.color", new Object[0]) + ": " + I18n.color(BlockCloth.func_21035_d((int)accessor.getNBTInteger("Color"))));
        }
        if (config.get("vanilla.tnt") && entity instanceof EntityTNTPrimed) {
            String fuseSeconds = String.format("%.2f", Float.valueOf((float)accessor.getNBTInteger("Fuse") / 20.0f));
            currenttip.add(I18n.translate("hud.msg.fuse", new Object[0]) + ": " + I18n.translate("hud.msg.seconds_format", fuseSeconds));
        }
    }

    @Override
    public void modifyTail(Entity entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(Entity ent, NBTTagCompound tag, IServerEntityAccessor accessor, IPluginConfig config) {
    }
}

