/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.event.WailaEventRegistrar;
import mcp.mobius.waila.api.event.WailaRegisterEvent;
import mcp.mobius.waila.api.impl.ConfigModule;
import mcp.mobius.waila.utils.config.Configuration;
import mcp.mobius.waila.utils.config.Property;

public class PluginConfig
implements IPluginConfig {
    private static PluginConfig _instance = null;
    private final Map<String, ConfigModule> modules = new LinkedHashMap<String, ConfigModule>();
    public Configuration config = null;

    private PluginConfig() {
        _instance = this;
    }

    public static PluginConfig instance() {
        return _instance == null ? new PluginConfig() : _instance;
    }

    public ConfigModule addModule(String modName) {
        return this.addModule(modName, new ConfigModule(modName));
    }

    public ConfigModule addModule(String modName, ConfigModule options) {
        this.modules.put(modName, options);
        return options;
    }

    @Override
    public Set<String> getModuleNames() {
        return this.modules.keySet();
    }

    @Override
    public Set<String> getKeys(String modName) {
        return this.modules.containsKey(modName) ? this.modules.get((Object)modName).options : new HashSet<String>();
    }

    public void addSyncedConfig(String modName, String key) {
        this.addSyncedConfig(modName, key, true);
    }

    public void addSyncedConfig(String modName, String key, boolean defValue) {
        WailaRegisterEvent.Config event = new WailaRegisterEvent.Config(modName, key, defValue);
        WailaEventRegistrar.postConfigRegister(event);
        this.config.getOrCreateBooleanProperty(key, "modules", defValue);
        this.config.getOrCreateBooleanProperty(key, "serverforcing", false);
        this.config.save();
        if (!this.modules.containsKey(modName)) {
            this.addModule(modName);
        }
        this.modules.get(modName).addOption(key);
    }

    @Override
    public boolean get(String key) {
        return this.get(key, true);
    }

    @Override
    public boolean get(String key, boolean defValue) {
        Property prop = this.config.getOrCreateBooleanProperty(key, "modules", defValue);
        return prop.getBoolean(defValue);
    }

    @Override
    public boolean set(String key, boolean value) {
        Property prop = this.config.getOrCreateBooleanProperty(key, "modules", value);
        prop.value = Boolean.toString(value);
        this.config.save();
        return true;
    }

    public boolean get(String category, String key, boolean default_) {
        Property prop = this.config.getOrCreateBooleanProperty(key, category, default_);
        return prop.getBoolean(default_);
    }

    public void setConfig(String category, String key, boolean state) {
        this.config.getOrCreateBooleanProperty((String)key, (String)category, (boolean)state).value = String.valueOf(state);
        this.config.save();
    }

    public int get(String category, String key, int default_) {
        Property prop = this.config.getOrCreateIntProperty(key, category, default_);
        return prop.getInt();
    }

    public void setConfig(String category, String key, int state) {
        this.config.getOrCreateIntProperty((String)key, (String)category, (int)state).value = String.valueOf(state);
        this.config.save();
    }

    public void loadDefaultConfig(Configuration cfg) {
        this.config = cfg;
        this.config.load();
        this.config.save();
    }
}

