/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.impl.PluginConfig;
import net.minecraft.server.Entity;

public class WailaRegistrar
implements IRegistrar {
    private static WailaRegistrar instance = null;
    public final Map<Class<?>, List<IDataProvider>> NBTDataProviders = new LinkedHashMap();
    public final Map<Class<?>, List<IEntityProvider>> NBTEntityProviders = new LinkedHashMap();

    private WailaRegistrar() {
        instance = this;
    }

    public static WailaRegistrar instance() {
        return instance == null ? new WailaRegistrar() : instance;
    }

    @Override
    public void addSyncedConfig(String modName, String key) {
        this.addSyncedConfig(modName, key, true);
    }

    @Override
    public void addSyncedConfig(String modName, String key, boolean defValue) {
        PluginConfig.instance().addSyncedConfig(modName, key, defValue);
    }

    @Override
    public void registerNBTProvider(IDataProvider dataProvider, Class<?> block) {
        this.registerProvider(dataProvider, block, this.NBTDataProviders);
    }

    @Override
    public void registerNBTProvider(IEntityProvider dataProvider, Class<?> entity) {
        this.registerProvider(dataProvider, entity, this.NBTEntityProviders);
    }

    private <T, V> void registerProvider(T dataProvider, V clazz, Map<V, List<T>> target) {
        List<T> providers;
        if (clazz == null || dataProvider == null) {
            throw new RuntimeException(String.format("Trying to register a null provider or null block! Please check the stacktrace to know what was the original registration method. [Provider: %s, Target: %s]", dataProvider == null ? "null" : dataProvider.getClass().getName(), clazz));
        }
        if (!target.containsKey(clazz)) {
            target.put(clazz, (List<T>)new ArrayList());
        }
        if (!(providers = target.get(clazz)).contains(dataProvider)) {
            target.get(clazz).add(dataProvider);
        }
    }

    public Map<Integer, List<IDataProvider>> getNBTProviders(Object block) {
        return this.getProviders(block, this.NBTDataProviders);
    }

    public Map<Integer, List<IEntityProvider>> getNBTEntityProviders(Object entity) {
        return this.getProviders(entity, this.NBTEntityProviders);
    }

    private <V, T> Map<Integer, List<T>> getProviders(V obj, Map<Class<? extends V>, List<T>> target) {
        TreeMap<Integer, List<T>> returnList = new TreeMap<Integer, List<T>>();
        int index = 0;
        for (Class<V> clazz : target.keySet()) {
            if (clazz.isInstance(obj)) {
                returnList.put(index, target.get(clazz));
            }
            ++index;
        }
        return returnList;
    }

    public boolean hasNBTProviders(Object block) {
        return this.hasProviders(block, this.NBTDataProviders);
    }

    public boolean hasNBTEntityProviders(Entity entity) {
        return this.hasProviders(entity, this.NBTEntityProviders);
    }

    private <V, T> boolean hasProviders(Object obj, Map<Class<? extends V>, List<T>> target) {
        for (Class<V> clazz : target.keySet()) {
            if (!clazz.isInstance(obj)) continue;
            return true;
        }
        return false;
    }
}

