/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.redpower;

import java.util.ArrayList;
import mcp.mobius.waila.addons.redpower.RedPowerPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public final class HUDHandlerMicroBlocks
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerMicroBlocks();

    private HUDHandlerMicroBlocks() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        World w = accessor.getWorld();
        EntityPlayer p = accessor.getPlayer();
        MovingObjectPosition mop = accessor.getPosition();
        TileEntity te = accessor.getTileEntity();
        try {
            if (RedPowerPlugin.TileCoverable.isInstance(te)) {
                TileEntity tl;
                MovingObjectPosition pos = (MovingObjectPosition)RedPowerPlugin.CoreLib_retraceBlock.invoke(null, w, p, mop.blockX, mop.blockY, mop.blockZ);
                if (pos != null && pos.typeOfHit == EnumMovingObjectType.TILE && (tl = (TileEntity)RedPowerPlugin.CoreLib_getTileEntity.invoke(null, w, mop.blockX, mop.blockY, mop.blockZ, RedPowerPlugin.TileCoverable)) != null) {
                    Block bm = (Block)RedPowerPlugin.RedPowerBase_blockMicro.get(null);
                    if (RedPowerPlugin.TileLogic != null && RedPowerPlugin.TileLogic.isInstance(tl)) {
                        if (pos.subHit == RedPowerPlugin.TileLogic_Rotation.getInt(tl) >> 2) {
                            if (RedPowerPlugin.TileLogic_Cover.getInt(tl) != 255) {
                                return new ItemStack(((Integer)RedPowerPlugin.TileExtended_getBlockID.invoke((Object)tl, new Object[0])).intValue(), 1, ((Integer)RedPowerPlugin.TileExtended_getExtendedID.invoke((Object)tl, new Object[0])).intValue());
                            }
                            ArrayList stacks = new ArrayList();
                            RedPowerPlugin.TileMultipart_addHarvestContents.invoke((Object)tl, stacks);
                            if (!stacks.isEmpty()) {
                                return (ItemStack)stacks.get(0);
                            }
                        }
                        return HUDHandlerMicroBlocks.getCover(tl, pos.subHit);
                    }
                    if (RedPowerPlugin.TileTube != null && RedPowerPlugin.TileTube.isInstance(tl)) {
                        if (pos.subHit == 29) {
                            return new ItemStack(bm.blockID, 1, (Integer)RedPowerPlugin.TileExtended_getExtendedID.invoke((Object)tl, new Object[0]) << 8);
                        }
                        return HUDHandlerMicroBlocks.getCover(tl, pos.subHit);
                    }
                    if (RedPowerPlugin.TileWiring != null && RedPowerPlugin.TileWiring.isInstance(tl)) {
                        if (pos.subHit == 29 && (RedPowerPlugin.TileWiring_ConSides.getInt(tl) & 0x40) > 0) {
                            int td = 16384 + RedPowerPlugin.TileWiring_CenterPost.getShort(tl);
                            int extId = (Integer)RedPowerPlugin.TileExtended_getExtendedID.invoke((Object)tl, new Object[0]);
                            if (extId == 3) {
                                td += 256;
                            }
                            if (extId == 5) {
                                td += 512;
                            }
                            return new ItemStack(bm.blockID, 1, td);
                        }
                        if ((RedPowerPlugin.TileWiring_ConSides.getInt(tl) & 1 << pos.subHit) <= 0) {
                            return HUDHandlerMicroBlocks.getCover(tl, pos.subHit);
                        }
                        return new ItemStack(bm.blockID, 1, (Integer)RedPowerPlugin.TileExtended_getExtendedID.invoke((Object)tl, new Object[0]) * 256 + RedPowerPlugin.TileWiring_Metadata.getInt(tl));
                    }
                    return HUDHandlerMicroBlocks.getCover(tl, pos.subHit);
                }
            } else if (RedPowerPlugin.TileMultipart.isInstance(te)) {
                ArrayList is = new ArrayList();
                RedPowerPlugin.TileMultipart_addHarvestContents.invoke((Object)te, is);
                if (!is.isEmpty()) {
                    return (ItemStack)is.get(0);
                }
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
    }

    private static ItemStack getCover(TileEntity te, int subHit) throws Throwable {
        int tr;
        if (((Integer)RedPowerPlugin.TileCoverable_getCoverMask.invoke((Object)te, new Object[0]) & 1 << subHit) != 0 && (tr = ((Integer)RedPowerPlugin.TileCoverable_getCover.invoke((Object)te, subHit)).intValue()) >= 0) {
            return (ItemStack)RedPowerPlugin.CoverLib_convertCoverPlate.invoke(null, subHit, tr);
        }
        return null;
    }
}

