/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import java.util.Random;
import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.ConstantRandom;
import mcp.mobius.waila.utils.I18n;
import net.minecraft.src.Block;
import net.minecraft.src.BlockRedstoneOre;
import net.minecraft.src.BlockStep;
import net.minecraft.src.Item;
import net.minecraft.src.ItemRecord;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityMobSpawner;

public final class HUDHandlerVanilla
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerVanilla();
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};

    private HUDHandlerVanilla() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == VanillaPlugin.redstone) {
            return new ItemStack(Item.redstone);
        }
        if (block instanceof BlockRedstoneOre) {
            return new ItemStack(Block.oreRedstone);
        }
        if (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv) {
            return new ItemStack(Item.redstoneRepeater);
        }
        if (block == VanillaPlugin.sugarCane) {
            return new ItemStack(Item.reed);
        }
        if (block == VanillaPlugin.crops) {
            return new ItemStack(Item.wheat);
        }
        if (block == VanillaPlugin.bed) {
            return new ItemStack(Item.bed);
        }
        if (block == VanillaPlugin.leave && meta > 3) {
            return new ItemStack(block, 1, meta - 4);
        }
        if (block == VanillaPlugin.log) {
            return new ItemStack(block, 1, meta % 4);
        }
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        if (block == VanillaPlugin.mobSpawner && accessor.getTileEntity() instanceof TileEntityMobSpawner && config.get("vanilla.spawntype")) {
            String name = (String)currenttip.get(0);
            String mobname = ((TileEntityMobSpawner)accessor.getTileEntity()).getMobID();
            currenttip.set(0, name + " (" + mobname + ")");
        }
        if (block == VanillaPlugin.pistonExtension) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonExtension.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonMoving) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonMoving.name", new Object[0]));
        }
        if (block instanceof BlockStep) {
            currenttip.set(0, "\u00a7f" + DisplayUtil.itemDisplayNameShort(new ItemStack(block.idDropped(accessor.getMetadata(), (Random)ConstantRandom.INSTANCE), 1, accessor.getMetadata() > 3 ? 0 : accessor.getMetadata())));
        }
        if (block == VanillaPlugin.tallGrass) {
            switch (accessor.getMetadata()) {
                case 0: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.tallgrass.shrub.name", new Object[0]));
                    break;
                }
                case 1: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.tallgrass.grass.name", new Object[0]));
                    break;
                }
                case 2: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.tallgrass.fern.name", new Object[0]));
                    break;
                }
                default: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.tallgrass.name", new Object[0]));
                }
            }
        }
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (config.get("vanilla.leverstate") && block == VanillaPlugin.lever) {
            String redstoneOn = (meta & 8) == 0 ? I18n.translate("hud.msg.off", new Object[0]) : I18n.translate("hud.msg.on", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + redstoneOn);
        }
        if (config.get("vanilla.repeater") && (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv)) {
            int tick = ((meta & 0xC) >> 2) + 1;
            if (tick == 1) {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": 1 tick");
            } else {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": " + tick + " ticks");
            }
        }
        if (config.get("vanilla.redstone") && block == VanillaPlugin.redstone) {
            currenttip.add(I18n.translate("hud.msg.power", new Object[0]) + ": " + meta);
        }
        if (config.get("vanilla.jukebox") && block == VanillaPlugin.jukebox) {
            NBTTagCompound tag = accessor.getNBTData();
            Item record = null;
            if (tag.hasKey("Record")) {
                record = Item.itemsList[accessor.getNBTInteger(tag, "Record")];
            }
            currenttip.add(record == null ? I18n.translate("hud.msg.empty", new Object[0]) : I18n.translate("hud.msg.record", new Object[0]) + ": " + "C418 - " + ((ItemRecord)record).recordName);
        }
        if (config.get("vanilla.noteblock") && block == VanillaPlugin.noteBlock) {
            int note = accessor.getNBTInteger("note");
            currenttip.add(I18n.translate("hud.msg.note", new Object[0]) + ": " + NOTES[note % 12] + (note / 12 + 1));
            MovingObjectPosition mop = accessor.getPosition();
            Material m = accessor.getWorld().getBlockMaterial(mop.blockX, mop.blockY - 1, mop.blockZ);
            String instrument = "hud.msg.piano";
            if (m == Material.rock) {
                instrument = "hud.msg.bass_drum";
            } else if (m == Material.sand) {
                instrument = "hud.msg.snare_drum";
            } else if (m == Material.glass) {
                instrument = "hud.msg.clicks_sticks";
            } else if (m == Material.wood) {
                instrument = "hud.msg.bass_guitar";
            }
            currenttip.add(I18n.translate("hud.msg.instrument", new Object[0]) + ": " + I18n.translate(instrument, new Object[0]));
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
    }
}

