/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.utils.SpawnUtil;
import org.lwjgl.opengl.GL11;
import reforged.IRenderWorldLastHandler;

public class NEIOverlayRenderer
implements IRenderWorldLastHandler {
    public static int renderChunkBounds = 0;
    public static boolean renderMobSpawnOverlay = false;
    public static int worldHeight = 127;

    public void onRenderWorldLast(n renderer, float partialTicks) {
        GL11.glPushMatrix();
        ls entity = ModLoader.getMinecraftInstance().i;
        double interpPosX = entity.bl + (entity.aM - entity.bl) * (double)partialTicks;
        double interpPosY = entity.bm + (entity.aN - entity.bm) * (double)partialTicks;
        double interpPosZ = entity.bn + (entity.aO - entity.bn) * (double)partialTicks;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
        NEIOverlayRenderer.renderChunkBounds((sn)entity);
        NEIOverlayRenderer.renderMobSpawnOverlay((sn)entity);
        GL11.glPopMatrix();
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : Math.min(value, max);
    }

    private static void renderMobSpawnOverlay(sn entity) {
        if (!renderMobSpawnOverlay) {
            return;
        }
        boolean oldOverlay = PluginConfig.instance().get("general.oldlightlevelol");
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        byte curSpawnMode = 2;
        fd world = entity.aI;
        int x1 = (int)entity.aM;
        int z1 = (int)entity.aO;
        int y1 = (int)NEIOverlayRenderer.clamp(entity.aN, 16.0, worldHeight - 16);
        eq aabb = eq.a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        for (int x2 = x1 - 16; x2 <= x1 + 16; ++x2) {
            for (int z2 = z1 - 16; z2 <= z1 + 16; ++z2) {
                lm chunk = world.b(x2, z2);
                kd biome = world.a().a(x2, z2);
                if (biome.a(lk.a).isEmpty()) continue;
                for (int y2 = y1 - 16; y2 < y1 + 16; ++y2) {
                    byte spawnMode = SpawnUtil.getSpawnMode(chunk, aabb, x2, y2, z2);
                    if (spawnMode == 0) continue;
                    if (spawnMode != curSpawnMode) {
                        if (spawnMode == 2 || oldOverlay) {
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                        }
                        curSpawnMode = spawnMode;
                    }
                    GL11.glVertex3d((double)x2, (double)((double)y2 + 0.004), (double)z2);
                    GL11.glVertex3d((double)(x2 + 1), (double)((double)y2 + 0.004), (double)(z2 + 1));
                    GL11.glVertex3d((double)(x2 + 1), (double)((double)y2 + 0.004), (double)z2);
                    GL11.glVertex3d((double)x2, (double)((double)y2 + 0.004), (double)(z2 + 1));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private static void renderChunkBounds(sn entity) {
        if (renderChunkBounds == 0) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        for (int cx = -4; cx <= 4; ++cx) {
            for (int cz = -4; cz <= 4; ++cz) {
                double x1 = entity.bG + cx << 4;
                double z1 = entity.bI + cz << 4;
                double x2 = x1 + 16.0;
                double z2 = z1 + 16.0;
                double dy = 128.0;
                double y1 = Math.floor(entity.aN - dy / 2.0);
                double y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)worldHeight) {
                    y2 = worldHeight;
                    y1 = y2 - dy;
                }
                double dist = Math.pow(1.5, -(cx * cx + cz * cz));
                GL11.glColor4d((double)0.9, (double)0.0, (double)0.0, (double)dist);
                if (cx >= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z2);
                }
                if (cx >= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z1);
                }
                if (cx <= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z2);
                }
                if (cx <= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z1);
                }
                if (renderChunkBounds != 2 || cx != 0 || cz != 0) continue;
                dy = 32.0;
                y1 = Math.floor(entity.aN - dy / 2.0);
                y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)worldHeight) {
                    y2 = worldHeight;
                    y1 = y2 - dy;
                }
                GL11.glColor4d((double)0.0, (double)0.9, (double)0.0, (double)0.4);
                for (double y3 = (double)((int)y1); y3 <= y2; y3 += 1.0) {
                    GL11.glVertex3d((double)x2, (double)y3, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y3, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y3, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y3, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y3, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y3, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y3, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y3, (double)z1);
                }
                for (double h2 = 1.0; h2 <= 15.0; h2 += 1.0) {
                    GL11.glVertex3d((double)(x1 + h2), (double)y1, (double)z1);
                    GL11.glVertex3d((double)(x1 + h2), (double)y2, (double)z1);
                    GL11.glVertex3d((double)(x1 + h2), (double)y1, (double)z2);
                    GL11.glVertex3d((double)(x1 + h2), (double)y2, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y1, (double)(z1 + h2));
                    GL11.glVertex3d((double)x1, (double)y2, (double)(z1 + h2));
                    GL11.glVertex3d((double)x2, (double)y1, (double)(z1 + h2));
                    GL11.glVertex3d((double)x2, (double)y2, (double)(z1 + h2));
                }
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

