/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import mcp.mobius.waila.api.event.WailaEventRegistrar;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.utils.GLState;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public final class OverlayRenderer {
    private OverlayRenderer() {
        throw new UnsupportedOperationException();
    }

    public static void renderOverlay(Tooltip tooltip) {
        Minecraft mc = ModLoader.getMinecraftInstance();
        if (mc.r != null && !(mc.r instanceof gc) || mc.f == null || !Minecraft.t() || mc.z.B && PluginConfig.instance().get("general", "waila.cfg.hideindebug", true) || !PluginConfig.instance().showTooltip() || RayTracing.instance().getTarget() == null) {
            return;
        }
        if (RayTracing.instance().getTarget().a == jg.a && RayTracing.instance().getTargetStack() != null) {
            OverlayRenderer.doRenderOverlay(tooltip);
        }
        if (RayTracing.instance().getTarget().a == jg.b && PluginConfig.instance().get("general.showents")) {
            OverlayRenderer.doRenderOverlay(tooltip);
        }
    }

    private static void doRenderOverlay(Tooltip tooltip) {
        GLState state = new GLState();
        try {
            GL11.glScalef((float)OverlayConfig.scale, (float)OverlayConfig.scale, (float)1.0f);
            WailaRenderEvent.Pre preEvent = new WailaRenderEvent.Pre(tooltip.pos, DataAccessorCommon.INSTANCE, OverlayConfig.bgcolor, OverlayConfig.gradient1, OverlayConfig.gradient2);
            if (!WailaEventRegistrar.postPreRender(preEvent)) {
                Rectangle position = preEvent.getPosition();
                OverlayRenderer.drawTooltipBox(position, preEvent.getBackground(), preEvent.getGradientStart(), preEvent.getGradientEnd());
                tooltip.drawAll();
                if (tooltip.hasItem()) {
                    int align = PluginConfig.instance().get("general", "waila.cfg.iconalign", 1);
                    int y = position.getY() + (align == 0 ? 5 : (align == 2 ? position.getHeight() - 19 : position.getHeight() / 2 - 8));
                    DisplayUtil.renderStack(position.getX() + 5, y, tooltip.stack);
                }
                WailaRenderEvent.Post postEvent = new WailaRenderEvent.Post(position);
                WailaEventRegistrar.postPostRender(postEvent);
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, tooltip.getClass(), null);
        }
        state.reset();
    }

    private static void drawTooltipBox(Rectangle position, int bg, int grad1, int grad2) {
        OverlayRenderer.drawTooltipBox(position.getX(), position.getY(), position.getWidth(), position.getHeight(), bg, grad1, grad2);
    }

    private static void drawTooltipBox(int x, int y, int w, int h2, int bg, int grad1, int grad2) {
        DisplayUtil.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + h2, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, h2 - 1, bg, bg);
        DisplayUtil.drawGradientRect(x, y + 1, 1, h2 - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + w, y + 1, 1, h2 - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 2, 1, h2 - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + w - 1, y + 2, 1, h2 - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        DisplayUtil.drawGradientRect(x + 1, y + h2 - 1, w - 1, 1, grad2, grad2);
    }
}

