/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.utils.NBTUtil;
import net.minecraftforge.common.ForgeDirection;

public class DataAccessorCommon
implements ICommonAccessor,
IDataAccessor,
IEntityAccessor {
    public xv world;
    public qx player;
    public anz mop;
    public aob renderingvec = null;
    public amj block;
    public int blockID;
    public int metadata;
    public anq tileEntity;
    public lq entity;
    public bq remoteNbt = null;
    public long timeLastUpdate = System.currentTimeMillis();
    public double partialFrame;
    public um stack;
    public static final DataAccessorCommon INSTANCE = new DataAccessorCommon();

    public void set(xv _world, qx _player, anz _mop) {
        this.set(_world, _player, _mop, null, 0.0);
    }

    public void set(xv _world, qx _player, anz _mop, md viewEntity, double partialTicks) {
        this.world = _world;
        this.player = _player;
        this.mop = _mop;
        if (this.mop.a == aoa.a) {
            this.blockID = this.world.a(_mop.b, _mop.c, _mop.d);
            this.metadata = this.world.h(_mop.b, _mop.c, _mop.d);
            this.block = amj.p[this.blockID];
            this.tileEntity = this.world.q(_mop.b, _mop.c, _mop.d);
            this.entity = null;
            try {
                this.stack = new um(this.block, 1, this.metadata);
            }
            catch (Throwable ignored) {}
        } else if (this.mop.a == aoa.b) {
            this.block = null;
            this.metadata = -1;
            this.tileEntity = null;
            this.stack = null;
            this.entity = _mop.g;
        }
        if (viewEntity != null) {
            double px = viewEntity.T + (viewEntity.t - viewEntity.T) * partialTicks;
            double py2 = viewEntity.U + (viewEntity.u - viewEntity.U) * partialTicks;
            double pz2 = viewEntity.V + (viewEntity.v - viewEntity.V) * partialTicks;
            this.renderingvec = aob.a((double)((double)_mop.b - px), (double)((double)_mop.c - py2), (double)((double)_mop.d - pz2));
            this.partialFrame = partialTicks;
        }
    }

    @Override
    public xv getWorld() {
        return this.world;
    }

    @Override
    public qx getPlayer() {
        return this.player;
    }

    @Override
    public amj getBlock() {
        return this.block;
    }

    @Override
    public int getBlockID() {
        return this.blockID;
    }

    @Override
    public int getMetadata() {
        return this.metadata;
    }

    @Override
    public anq getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public lq getEntity() {
        return this.entity;
    }

    @Override
    public anz getPosition() {
        return this.mop;
    }

    @Override
    public aob getRenderingPosition() {
        return this.renderingvec;
    }

    @Override
    public bq getNBTData() {
        if (this.tileEntity != null && this.isTagCorrectTileEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.entity != null && this.isTagCorrectEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.tileEntity != null) {
            bq tag = new bq();
            try {
                this.tileEntity.b(tag);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return tag;
        }
        if (this.entity != null) {
            bq tag = new bq();
            this.entity.d(tag);
            return tag;
        }
        return null;
    }

    public void setNBTData(bq tag) {
        this.remoteNbt = tag;
    }

    private boolean isTagCorrectTileEntity(bq tag) {
        if (!(tag != null && tag.b("WailaX") && tag.b("WailaY") && tag.b("WailaZ"))) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.e("WailaX");
        int y = tag.e("WailaY");
        int z = tag.e("WailaZ");
        if (x == this.mop.b && y == this.mop.c && z == this.mop.d) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity(bq tag) {
        if (tag == null || !tag.b("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.e("WailaEntityID");
        if (id == this.entity.k) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    @Override
    public int getNBTInteger(String keyname) {
        return this.getNBTInteger(this.getNBTData(), keyname);
    }

    @Override
    public int getNBTInteger(bq tag, String keyname) {
        return NBTUtil.getNBTInteger(tag, keyname);
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    @Override
    public ForgeDirection getSide() {
        return ForgeDirection.getOrientation((int)this.getPosition().e);
    }

    @Override
    public um getStack() {
        return this.stack;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

