/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.utils.GLState;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public final class OverlayRenderer {
    private OverlayRenderer() {
        throw new UnsupportedOperationException();
    }

    public static void renderOverlay() {
        Minecraft mc = Minecraft.x();
        if (mc.r != null && !(mc.r instanceof asw) || mc.e == null || !Minecraft.s() || mc.y.U && PluginConfig.instance().get("general", "waila.cfg.hideindebug", true) || mc.y.M.e && (!mc.A() || mc.g.a.c.size() > 1) || !PluginConfig.instance().showTooltip() || RayTracing.instance().getTarget() == null) {
            return;
        }
        if (RayTracing.instance().getTarget().a == aoa.a && RayTracing.instance().getTargetStack() != null) {
            OverlayRenderer.renderOverlay(mod_BlockHelper.TICK_HANDLER.tooltip);
        }
        if (RayTracing.instance().getTarget().a == aoa.b && PluginConfig.instance().get("general.showents")) {
            OverlayRenderer.renderOverlay(mod_BlockHelper.TICK_HANDLER.tooltip);
        }
    }

    public static void renderOverlay(Tooltip tooltip) {
        Minecraft.x().I.a("Waila Overlay");
        GLState state = new GLState();
        try {
            GL11.glScalef((float)OverlayConfig.scale, (float)OverlayConfig.scale, (float)1.0f);
            WailaRenderEvent.Pre preEvent = new WailaRenderEvent.Pre(tooltip.pos, DataAccessorCommon.INSTANCE, OverlayConfig.bgcolor, OverlayConfig.gradient1, OverlayConfig.gradient2);
            if (!MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
                Rectangle position = preEvent.getPosition();
                OverlayRenderer.drawTooltipBox(position, preEvent.getBackground(), preEvent.getGradientStart(), preEvent.getGradientEnd());
                tooltip.drawAll();
                if (tooltip.hasItem()) {
                    DisplayUtil.renderStack(position.getX() + 5, position.getY() + position.getHeight() / 2 - 8, tooltip.stack);
                }
                WailaRenderEvent.Post postEvent = new WailaRenderEvent.Post(position);
                MinecraftForge.EVENT_BUS.post((Event)postEvent);
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, tooltip.getClass(), null);
        }
        state.reset();
        Minecraft.x().I.b();
    }

    public static void drawTooltipBox(Rectangle position, int bg, int grad1, int grad2) {
        OverlayRenderer.drawTooltipBox(position.getX(), position.getY(), position.getWidth(), position.getHeight(), bg, grad1, grad2);
    }

    public static void drawTooltipBox(int x, int y, int w, int h, int bg, int grad1, int grad2) {
        DisplayUtil.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        DisplayUtil.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }
}

