/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import mcp.mobius.waila.utils.I18n;

public final class ModIdentification {
    public static Map<String, String> modSource = new HashMap<String, String>();
    public static Map<Integer, String> itemMap = new HashMap<Integer, String>();

    private ModIdentification() {
        throw new UnsupportedOperationException();
    }

    public static void init() {
        by itemDataList = new by();
        GameData.writeItemData((by)itemDataList);
        for (int i = 0; i < itemDataList.c(); ++i) {
            ItemData itemData = new ItemData((bq)itemDataList.b(i));
            itemMap.put(itemData.getItemId(), itemData.getModId());
        }
        for (ModContainer mod : Loader.instance().getModList()) {
            modSource.put(mod.getSource().getName(), ModIdentification.formatModName(mod.getName()));
        }
        modSource.put("minecraft.jar", "Minecraft");
        modSource.put("Forge", "Minecraft");
        modSource.put("Forge Mod Loader", "Minecraft");
        modSource.put("Minecraft Forge", "Minecraft");
        modSource.put("Minecraft Coder Pack", "Minecraft");
        modSource.put("Mod Coder Pack", "Minecraft");
    }

    public static String nameFromObject(Object obj) {
        String objPath = obj.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        try {
            objPath = URLDecoder.decode(objPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            mod_BlockHelper.LOG.log(Level.WARNING, "nameFromObject", e);
        }
        String modName = null;
        for (String s : modSource.keySet()) {
            if (!objPath.contains(s)) continue;
            modName = modSource.get(s);
            break;
        }
        if (modName == null) {
            modName = "<" + I18n.translate("hud.msg.unknown", new Object[0]) + ">";
        } else if (modName.equals("Minecraft Coder Pack")) {
            modName = "Minecraft";
        }
        return modName;
    }

    public static String nameFromStack(um stack) {
        try {
            String modID = itemMap.get(stack.c);
            ModContainer mod = ModIdentification.findModContainer(modID);
            return mod == null ? "Minecraft" : ModIdentification.formatModName(mod.getName());
        }
        catch (NullPointerException e) {
            mod_BlockHelper.LOG.log(Level.FINEST, "nameFromStack", e);
            return "";
        }
    }

    public static ModContainer findModContainer(String modID) {
        for (ModContainer mc : Loader.instance().getModList()) {
            if (!modID.equals(mc.getModId())) continue;
            return mc;
        }
        return null;
    }

    private static String formatModName(String name) {
        return name == null ? "Minecraft" : name.replaceFirst("^mod_", "").replaceAll("\u00c2\u00a7.", "").replaceAll("\u00a7.", "");
    }
}

