/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.EntityRegistry;
import mcp.mobius.waila.addons.core.CorePlugin;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerEntityAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class HUDHandlerEntities
implements IEntityProvider {
    public static final IEntityProvider INSTANCE = new HUDHandlerEntities();

    private HUDHandlerEntities() {
    }

    @Override
    public Entity getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public ItemStack getDisplayItem(IEntityAccessor accessor, IPluginConfig config) {
        if (accessor.getEntity() instanceof EntityLiving) {
            try {
                EntityLiving living = (EntityLiving)accessor.getEntity();
                int dropId = (Integer)CorePlugin.getDropItemId.invoke((Object)living, new Object[0]);
                if (dropId > 0) {
                    return new ItemStack(dropId, 1, 0);
                }
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getEntity().getClass(), null);
            }
        }
        return accessor.getEntity().getPickedResult(accessor.getPosition());
    }

    @Override
    public void modifyHead(Entity entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        String color = entity instanceof IMob ? "\u00a7c" : "\u00a7f";
        try {
            String entityName = entity.getEntityName();
            if (!(entityName == null || entityName.isEmpty() || entityName.startsWith("entity.") && entityName.endsWith(".name") && ((entityName = I18n.translate(entityName, new Object[0])) == null || entityName.isEmpty()))) {
                currenttip.add(color + entityName);
                return;
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        currenttip.add(color + I18n.translate("hud.msg.please_report", new Object[0]));
    }

    @Override
    public void modifyBody(Entity entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyTail(Entity entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        try {
            currenttip.add("\u00a79\u00a7o" + HUDHandlerEntities.getEntityMod(entity));
        }
        catch (Throwable t) {
            currenttip.add("\u00a79\u00a7o" + I18n.translate("hud.msg.unknown", new Object[0]));
        }
    }

    @Override
    public void appendServerData(Entity ent, NBTTagCompound tag, IServerEntityAccessor accessor, IPluginConfig config) {
        if (ent != null) {
            ent.writeToNBT(tag);
        }
    }

    private static String getEntityMod(Entity entity) {
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(entity.getClass(), true);
        if (er == null) {
            return "Minecraft";
        }
        ModContainer mod = er.getContainer();
        if (mod == null) {
            return "Minecraft";
        }
        return mod.getName();
    }
}

