/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.api.impl.ServerDataAccessorCommon;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.network.IWailaPacket;
import mcp.mobius.waila.network.Packet0x03NBTData;
import mcp.mobius.waila.network.WailaPacketHandler;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;

public class Packet0x02EntRequest
implements IWailaPacket {
    public int id;

    public Packet0x02EntRequest() {
    }

    public Packet0x02EntRequest(Entity ent) {
        this.id = ent.entityId;
    }

    @Override
    public void encode(DataOutputStream target) throws Exception {
        target.writeInt(this.id);
    }

    @Override
    public void decode(DataInputStream dat) {
        try {
            this.id = dat.readInt();
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, this.getClass(), null);
        }
    }

    @Override
    public void handleClient() {
    }

    @Override
    public void handleServer(Player rawSender) {
        if (!(rawSender instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)rawSender;
        WorldServer world = player.getServerForPlayer();
        if (world == null) {
            return;
        }
        Entity entity = world.getEntityByID(this.id);
        if (entity == null) {
            return;
        }
        try {
            NBTTagCompound tag = new NBTTagCompound();
            if (WailaRegistrar.instance().hasNBTEntityProviders(entity)) {
                ServerDataAccessorCommon accessor = ServerDataAccessorCommon.INSTANCE;
                accessor.set(world, player, entity);
                for (List<IEntityProvider> providersList : WailaRegistrar.instance().getNBTEntityProviders(entity).values()) {
                    for (IEntityProvider provider : providersList) {
                        try {
                            provider.appendServerData(entity, tag, accessor, PluginConfig.instance());
                        }
                        catch (Throwable t) {
                            WailaExceptionHandler.handleErr(t, entity.getClass(), null);
                        }
                    }
                }
            }
            tag.setInteger("WailaEntityID", entity.entityId);
            WailaPacketHandler.sendPacketToPlayer(new Packet0x03NBTData(tag), rawSender);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, entity.getClass(), null);
        }
    }
}

