/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.forge;

import mcp.mobius.waila.addons.forge.LiquidHelper;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.I18n;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public final class HUDHandlerForgeTanks
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerForgeTanks();

    private HUDHandlerForgeTanks() {
    }

    @Override
    public um getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(um itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get("forge.tanktype")) {
            LiquidStack stack = null;
            int capacity = 0;
            if (accessor.getTileEntity() instanceof ITankContainer) {
                bq compound = accessor.getNBTData();
                stack = compound.b("liquidstack") ? LiquidStack.loadLiquidStackFromNBT((bq)compound.l("liquidstack")) : null;
                capacity = accessor.getNBTInteger("liquidcapacity");
            } else if (accessor.getBlock() == amj.bJ) {
                int meta = accessor.getMetadata();
                stack = meta == 0 ? null : new LiquidStack(amj.E, Math.min(4, meta) * 250);
                capacity = 1000;
            }
            if (capacity > 0) {
                String name = (String)currenttip.get(0);
                name = name + " " + (stack == null ? I18n.translate("hud.msg.empty", new Object[0]) : "(" + DisplayUtil.itemDisplayNameShort(stack.asItemStack()) + "\u00a7r" + "\u00a7f" + ")");
                currenttip.set(0, name);
            }
        }
    }

    @Override
    public void modifyBody(um itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get("forge.tankamount")) {
            int liquidAmount = 0;
            int capacity = 0;
            if (accessor.getTileEntity() instanceof ITankContainer) {
                bq compound = accessor.getNBTData();
                LiquidStack stack = compound.b("liquidstack") ? LiquidStack.loadLiquidStackFromNBT((bq)compound.l("liquidstack")) : null;
                liquidAmount = stack != null ? stack.amount : 0;
                capacity = accessor.getNBTInteger("liquidcapacity");
            } else if (accessor.getBlock() == amj.bJ) {
                liquidAmount = Math.min(4, accessor.getMetadata()) * 250;
                capacity = 1000;
            }
            if (capacity > 0) {
                currenttip.add(liquidAmount + "/" + capacity + " mB");
            }
        }
    }

    @Override
    public void modifyTail(um itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(anq te, bq tag, IServerDataAccessor accessor, IPluginConfig config) {
        LiquidHelper.writeToNBT((ITankContainer)te, tag);
    }
}

