/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.I18n;

public final class HUDHandlerVanilla
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerVanilla();
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};

    private HUDHandlerVanilla() {
    }

    @Override
    public um getStack(IDataAccessor accessor, IPluginConfig config) {
        amj block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == VanillaPlugin.silverfish && config.get("vanilla.silverfish")) {
            switch (meta) {
                case 1: {
                    return new um(amj.z);
                }
                case 2: {
                    return new um(amj.bp);
                }
            }
            return new um(amj.w);
        }
        if (block == VanillaPlugin.redstone) {
            return new um(uk.aC);
        }
        if (block instanceof alp) {
            return new um(amj.aQ);
        }
        if (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv) {
            return new um(uk.bb);
        }
        if (block == VanillaPlugin.melonStem) {
            return new um(uk.bh);
        }
        if (block == VanillaPlugin.pumpkinStem) {
            return new um(uk.bg);
        }
        if (block == VanillaPlugin.sugarCane) {
            return new um(uk.aJ);
        }
        if (block == VanillaPlugin.crops) {
            return new um(uk.T);
        }
        if (block == VanillaPlugin.carrot) {
            return new um(uk.bK);
        }
        if (block == VanillaPlugin.potato) {
            return new um(uk.bL);
        }
        if (block == VanillaPlugin.flowerPot) {
            return new um(uk.bJ);
        }
        if (block == VanillaPlugin.cauldron) {
            return new um(uk.bz);
        }
        if (block == VanillaPlugin.bed) {
            return new um(uk.ba);
        }
        if (block == VanillaPlugin.leave && meta > 3) {
            return new um(block, 1, meta - 4);
        }
        if (block == VanillaPlugin.log) {
            return new um(block, 1, meta % 4);
        }
        return null;
    }

    @Override
    public void modifyHead(um itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        amj block = accessor.getBlock();
        if (block == VanillaPlugin.mobSpawner && accessor.getTileEntity() instanceof anl && config.get("vanilla.spawntype")) {
            String name = (String)currenttip.get(0);
            String mobname = ((anl)accessor.getTileEntity()).a();
            currenttip.set(0, name + " (" + mobname + ")");
        }
        if (block == VanillaPlugin.melonStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.melonStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.pumpkinStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pumpkinStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.endPortal) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.endPortal.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonExtension) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonExtension.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonMoving) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonMoving.name", new Object[0]));
        }
    }

    @Override
    public void modifyBody(um itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        String playerName;
        ano te;
        um flower;
        amj block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (config.get("vanilla.leverstate") && block == VanillaPlugin.lever) {
            String redstoneOn = (meta & 8) == 0 ? I18n.translate("hud.msg.off", new Object[0]) : I18n.translate("hud.msg.on", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + redstoneOn);
        }
        if (config.get("vanilla.repeater") && (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv)) {
            int tick = ((meta & 0xC) >> 2) + 1;
            if (tick == 1) {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": 1 tick");
            } else {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": " + tick + " ticks");
            }
        }
        if (config.get("vanilla.redstone") && block == VanillaPlugin.redstone) {
            currenttip.add(I18n.translate("hud.msg.power", new Object[0]) + ": " + meta);
        }
        if (config.get("vanilla.jukebox") && block == VanillaPlugin.jukebox) {
            bq tag = accessor.getNBTData();
            uk record = null;
            if (tag.b("RecordItem")) {
                um stack = um.a((bq)tag.l("RecordItem"));
                uk uk2 = record = stack == null ? null : stack.b();
            }
            if (record == null && tag.b("Record")) {
                record = uk.e[accessor.getNBTInteger(tag, "Record")];
            }
            currenttip.add(record == null ? I18n.translate("hud.msg.empty", new Object[0]) : I18n.translate("hud.msg.record", new Object[0]) + ": " + ((ux)record).g());
        }
        if (config.get("vanilla.flowerpot") && block == VanillaPlugin.flowerPot && (flower = ajz.c((int)meta)) != null) {
            currenttip.add(I18n.translate("hud.msg.flower", new Object[0]) + ": " + DisplayUtil.itemDisplayNameShort(flower));
        }
        if (config.get("vanilla.skull") && accessor.getTileEntity() instanceof ano && (te = (ano)accessor.getTileEntity()).a() == 3 && (playerName = te.c()) != null && !playerName.isEmpty()) {
            currenttip.add(I18n.translate("hud.msg.head_owner", new Object[0]) + ": " + playerName);
        }
        if (config.get("vanilla.noteblock") && block == VanillaPlugin.noteBlock) {
            int note = accessor.getNBTInteger("note");
            currenttip.add(I18n.translate("hud.msg.note", new Object[0]) + ": " + NOTES[note % 12] + (note / 12 + 1));
            anz mop = accessor.getPosition();
            agb m = accessor.getWorld().g(mop.b, mop.c - 1, mop.d);
            String instrument = "hud.msg.piano";
            if (m == agb.e) {
                instrument = "hud.msg.bass_drum";
            } else if (m == agb.p) {
                instrument = "hud.msg.snare_drum";
            } else if (m == agb.r) {
                instrument = "hud.msg.clicks_sticks";
            } else if (m == agb.d) {
                instrument = "hud.msg.bass_guitar";
            }
            currenttip.add(I18n.translate("hud.msg.instrument", new Object[0]) + ": " + I18n.translate(instrument, new Object[0]));
        }
        if (config.get("vanilla.beacon") && block == VanillaPlugin.beacon) {
            int level = accessor.getNBTInteger("Levels");
            int primary = accessor.getNBTInteger("Primary");
            int secondary = accessor.getNBTInteger("Secondary");
            if (level >= 0) {
                currenttip.add(I18n.translate("hud.msg.level", new Object[0]) + ": " + level);
            }
            if (primary > 0) {
                currenttip.add(I18n.translate("hud.msg.primary_effect", new Object[0]) + ": " + I18n.translate(ll.a[primary].a(), new Object[0]));
            }
            if (secondary > 0) {
                currenttip.add(I18n.translate("hud.msg.secondary_effect", new Object[0]) + ": " + I18n.translate(ll.a[secondary].a(), new Object[0]));
            }
        }
    }

    @Override
    public void modifyTail(um itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(anq te, bq tag, IServerDataAccessor accessor, IPluginConfig config) {
    }
}

