/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mcp.mobius.waila.api.IAdvDataProvider;
import mcp.mobius.waila.api.IAdvEntityProvider;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.client.ConfigKeyHandler;
import mcp.mobius.waila.network.Packet0x01TileRequest;
import mcp.mobius.waila.network.Packet0x02EntRequest;
import mcp.mobius.waila.network.WailaPacketHandler;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public class MetaDataProvider {
    private final Map<Integer, List<IDataProvider>> headBlockProviders = new TreeMap<Integer, List<IDataProvider>>();
    private final Map<Integer, List<IDataProvider>> bodyBlockProviders = new TreeMap<Integer, List<IDataProvider>>();
    private final Map<Integer, List<IDataProvider>> tailBlockProviders = new TreeMap<Integer, List<IDataProvider>>();
    private final Map<Integer, List<IEntityProvider>> headEntityProviders = new TreeMap<Integer, List<IEntityProvider>>();
    private final Map<Integer, List<IEntityProvider>> bodyEntityProviders = new TreeMap<Integer, List<IEntityProvider>>();
    private final Map<Integer, List<IEntityProvider>> tailEntityProviders = new TreeMap<Integer, List<IEntityProvider>>();

    public void handleBlockTextData(um itemStack, DataAccessorCommon accessor, ITaggedList<String, String> currenttip, TooltipPosition tooltipPosition) {
        amj block = accessor.getBlock();
        WailaRegistrar registrar = WailaRegistrar.instance();
        if (accessor.getTileEntity() != null && accessor.isTimeElapsed(250L) && PluginConfig.instance().showTooltip()) {
            if (mod_BlockHelper.INSTANCE.serverPresent) {
                accessor.resetTimer();
                if (registrar.hasNBTProviders(block) || registrar.hasNBTProviders(accessor.getTileEntity())) {
                    WailaPacketHandler.sendPacketToServer(new Packet0x01TileRequest(accessor.getTileEntity()));
                }
            } else {
                try {
                    bq tag = new bq();
                    accessor.getTileEntity().b(tag);
                    accessor.setNBTData(tag);
                }
                catch (Throwable t) {
                    WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
                }
            }
        }
        this.headBlockProviders.clear();
        this.bodyBlockProviders.clear();
        this.tailBlockProviders.clear();
        if (tooltipPosition == TooltipPosition.HEADER && registrar.hasHeadProviders(block)) {
            this.headBlockProviders.putAll(registrar.getHeadProviders(block));
        } else if (tooltipPosition == TooltipPosition.BODY && registrar.hasBodyProviders(block)) {
            this.bodyBlockProviders.putAll(registrar.getBodyProviders(block));
        } else if (tooltipPosition == TooltipPosition.FOOTER && registrar.hasTailProviders(block)) {
            this.tailBlockProviders.putAll(registrar.getTailProviders(block));
        }
        if (tooltipPosition == TooltipPosition.HEADER && registrar.hasHeadProviders(accessor.getTileEntity())) {
            this.headBlockProviders.putAll(registrar.getHeadProviders(accessor.getTileEntity()));
        } else if (tooltipPosition == TooltipPosition.BODY && registrar.hasBodyProviders(accessor.getTileEntity())) {
            this.bodyBlockProviders.putAll(registrar.getBodyProviders(accessor.getTileEntity()));
        } else if (tooltipPosition == TooltipPosition.FOOTER && registrar.hasTailProviders(accessor.getTileEntity())) {
            this.tailBlockProviders.putAll(registrar.getTailProviders(accessor.getTileEntity()));
        }
        if (tooltipPosition == TooltipPosition.HEADER) {
            for (List<IDataProvider> providersList : this.headBlockProviders.values()) {
                for (IDataProvider iDataProvider : providersList) {
                    try {
                        iDataProvider.modifyHead(itemStack, currenttip, accessor, PluginConfig.instance());
                    }
                    catch (Throwable t) {
                        WailaExceptionHandler.handleErr(t, iDataProvider.getClass(), currenttip);
                    }
                }
            }
        }
        if (tooltipPosition == TooltipPosition.BODY) {
            boolean showAdvancedBody = ConfigKeyHandler.showAdvancedBody;
            boolean hasAdvancedBodyAvailable = false;
            for (List list : this.bodyBlockProviders.values()) {
                for (IDataProvider dataProvider : list) {
                    try {
                        IAdvDataProvider advDataProvider;
                        dataProvider.modifyBody(itemStack, currenttip, accessor, PluginConfig.instance());
                        if (!(dataProvider instanceof IAdvDataProvider) || !(advDataProvider = (IAdvDataProvider)dataProvider).hasAdvancedBody(itemStack, accessor, PluginConfig.instance())) continue;
                        hasAdvancedBodyAvailable = true;
                        if (!showAdvancedBody) continue;
                        advDataProvider.modifyAdvancedBody(itemStack, currenttip, accessor, PluginConfig.instance());
                    }
                    catch (Throwable t) {
                        WailaExceptionHandler.handleErr(t, dataProvider.getClass(), currenttip);
                    }
                }
            }
            if (hasAdvancedBodyAvailable && !showAdvancedBody) {
                String keyName = asl.c((int)ConfigKeyHandler.advancedBodyKey);
                currenttip.add("\u00a7o" + I18n.translate("hud.msg.holdkeymoreinfo", keyName));
            }
        }
        if (tooltipPosition == TooltipPosition.FOOTER) {
            for (List<IDataProvider> providersList : this.tailBlockProviders.values()) {
                for (IDataProvider iDataProvider : providersList) {
                    try {
                        iDataProvider.modifyTail(itemStack, currenttip, accessor, PluginConfig.instance());
                    }
                    catch (Throwable t) {
                        WailaExceptionHandler.handleErr(t, iDataProvider.getClass(), currenttip);
                    }
                }
            }
        }
    }

    public void handleEntityTextData(lq entity, DataAccessorCommon accessor, ITaggedList<String, String> currenttip, TooltipPosition tooltipPosition) {
        WailaRegistrar registrar = WailaRegistrar.instance();
        if (accessor.getEntity() != null && accessor.isTimeElapsed(250L) && PluginConfig.instance().showTooltip()) {
            if (mod_BlockHelper.INSTANCE.serverPresent) {
                accessor.resetTimer();
                if (registrar.hasNBTEntityProviders(accessor.getEntity())) {
                    WailaPacketHandler.sendPacketToServer(new Packet0x02EntRequest(accessor.getEntity()));
                }
            } else {
                try {
                    bq tag = new bq();
                    accessor.getEntity().d(tag);
                    accessor.setNBTData(tag);
                }
                catch (Throwable t) {
                    WailaExceptionHandler.handleErr(t, accessor.getEntity().getClass(), currenttip);
                }
            }
        }
        this.headEntityProviders.clear();
        this.bodyEntityProviders.clear();
        this.tailEntityProviders.clear();
        if (tooltipPosition == TooltipPosition.HEADER && registrar.hasHeadEntityProviders(entity)) {
            this.headEntityProviders.putAll(registrar.getHeadEntityProviders(entity));
        } else if (tooltipPosition == TooltipPosition.BODY && registrar.hasBodyEntityProviders(entity)) {
            this.bodyEntityProviders.putAll(registrar.getBodyEntityProviders(entity));
        } else if (tooltipPosition == TooltipPosition.FOOTER && registrar.hasTailEntityProviders(entity)) {
            this.tailEntityProviders.putAll(registrar.getTailEntityProviders(entity));
        }
        if (tooltipPosition == TooltipPosition.HEADER) {
            for (List<IEntityProvider> providersList : this.headEntityProviders.values()) {
                for (IEntityProvider iEntityProvider : providersList) {
                    try {
                        iEntityProvider.modifyHead(entity, currenttip, accessor, PluginConfig.instance());
                    }
                    catch (Throwable t) {
                        WailaExceptionHandler.handleErr(t, iEntityProvider.getClass(), currenttip);
                    }
                }
            }
        }
        if (tooltipPosition == TooltipPosition.BODY) {
            boolean showAdvancedBody = ConfigKeyHandler.showAdvancedBody;
            boolean hasAdvancedBodyAvailable = false;
            for (List list : this.bodyEntityProviders.values()) {
                for (IEntityProvider dataProvider : list) {
                    try {
                        IAdvEntityProvider advDataProvider;
                        dataProvider.modifyBody(entity, currenttip, accessor, PluginConfig.instance());
                        if (!(dataProvider instanceof IAdvEntityProvider) || !(advDataProvider = (IAdvEntityProvider)dataProvider).hasAdvancedBody(entity, accessor, PluginConfig.instance())) continue;
                        hasAdvancedBodyAvailable = true;
                        if (!showAdvancedBody) continue;
                        advDataProvider.modifyAdvancedBody(entity, currenttip, accessor, PluginConfig.instance());
                    }
                    catch (Throwable t) {
                        WailaExceptionHandler.handleErr(t, dataProvider.getClass(), currenttip);
                    }
                }
            }
            if (hasAdvancedBodyAvailable && !showAdvancedBody) {
                String keyName = asl.c((int)ConfigKeyHandler.advancedBodyKey);
                currenttip.add("\u00a7o" + I18n.translate("hud.msg.holdkeymoreinfo", keyName));
            }
        }
        if (tooltipPosition == TooltipPosition.FOOTER) {
            for (List<IEntityProvider> providersList : this.tailEntityProviders.values()) {
                for (IEntityProvider iEntityProvider : providersList) {
                    try {
                        iEntityProvider.modifyTail(entity, currenttip, accessor, PluginConfig.instance());
                    }
                    catch (Throwable t) {
                        WailaExceptionHandler.handleErr(t, iEntityProvider.getClass(), currenttip);
                    }
                }
            }
        }
    }
}

