/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.bc3;

import mcp.mobius.waila.addons.bc3.BC3Plugin;
import mcp.mobius.waila.addons.bc3.LiquidHelper;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerEntityAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.Entity;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;

public final class HUDHandlerEntityBC3Tanks
implements IEntityProvider {
    public static final IEntityProvider INSTANCE = new HUDHandlerEntityBC3Tanks();

    private HUDHandlerEntityBC3Tanks() {
    }

    @Override
    public Entity getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public ItemStack getDisplayItem(IEntityAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(Entity entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        try {
            if (config.get("bc.tanktype")) {
                NBTTagCompound compound = accessor.getNBTData();
                Object stack = compound.hasKey("liquidstack") ? BC3Plugin.LiquidStack_loadLiquidStackFromNBT.invoke(null, compound.getCompoundTag("liquidstack")) : null;
                int capacity = accessor.getNBTInteger("liquidcapacity");
                if (capacity > 0) {
                    String name = (String)currenttip.get(0);
                    name = name + " " + (stack == null ? I18n.translate("hud.msg.empty", new Object[0]) : "(" + LiquidHelper.getLiquidName(stack) + "\u00a7r" + "\u00a7f" + ")");
                    currenttip.set(0, name);
                }
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyBody(Entity entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        try {
            if (config.get("bc.tankamount")) {
                NBTTagCompound compound = accessor.getNBTData();
                Object stack = compound.hasKey("liquidstack") ? BC3Plugin.LiquidStack_loadLiquidStackFromNBT.invoke(null, compound.getCompoundTag("liquidstack")) : null;
                int liquidAmount = stack != null ? BC3Plugin.LiquidStack_amount.getInt(stack) : 0;
                int capacity = accessor.getNBTInteger("liquidcapacity");
                if (capacity > 0) {
                    currenttip.add(liquidAmount + "/" + capacity + " mB");
                }
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(Entity entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(Entity ent, NBTTagCompound tag, IServerEntityAccessor accessor, IPluginConfig config) {
        LiquidHelper.writeToNBT(ent, tag);
    }
}

