/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.event.ClientFirstTickInWorldEvent;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.MetaDataProvider;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.api.impl.TipList;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.utils.FixDetector;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityClientPlayerMP;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.World;
import net.minecraft.src.WorldClient;
import net.minecraft.src.mod_BlockHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;

public class WailaTickHandler
implements ITickHandler {
    private Tooltip tooltip;
    private final MetaDataProvider handler = new MetaDataProvider();
    private final ITaggedList<String, String> currenttip = new TipList<String, String>();
    private final ITaggedList<String, String> currenttipHead = new TipList<String, String>();
    private final ITaggedList<String, String> currenttipBody = new TipList<String, String>();
    private final ITaggedList<String, String> currenttipTail = new TipList<String, String>();
    private boolean firstTick = true;

    public void tickStart(EnumSet<TickType> enumSet, Object ... objects) {
    }

    public void tickEnd(EnumSet<TickType> enumSet, Object ... objects) {
        if (enumSet.contains(TickType.RENDER)) {
            OverlayRenderer.renderOverlay(this.tooltip);
        }
        if (enumSet.contains(TickType.CLIENT)) {
            this.clientTick();
        }
    }

    private void clientTick() {
        Minecraft mc = Minecraft.getMinecraft();
        WorldClient world = mc.theWorld;
        EntityClientPlayerMP player = mc.thePlayer;
        if (world == null || player == null) {
            this.resetAll();
            return;
        }
        if (this.firstTick) {
            ModIdentification.init();
            FixDetector.detectFixes(mc);
            mod_BlockHelper.UPDATER.notifyUpdater(mc);
            MinecraftForge.EVENT_BUS.post((Event)new ClientFirstTickInWorldEvent(mc));
            this.firstTick = false;
        }
        RayTracing.instance().fire();
        MovingObjectPosition target = RayTracing.instance().getTarget();
        if (target != null && target.typeOfHit == EnumMovingObjectType.TILE) {
            DataAccessorCommon accessor = DataAccessorCommon.INSTANCE;
            accessor.set((World)world, (EntityPlayer)player, target);
            ItemStack targetStack = RayTracing.instance().getTargetStack();
            if (targetStack != null) {
                this.currenttip.clear();
                this.currenttipHead.clear();
                this.currenttipBody.clear();
                this.currenttipTail.clear();
                this.handler.handleBlockTextData(targetStack, accessor, this.currenttipHead, TooltipPosition.HEADER);
                this.handler.handleBlockTextData(targetStack, accessor, this.currenttipBody, TooltipPosition.BODY);
                this.handler.handleBlockTextData(targetStack, accessor, this.currenttipTail, TooltipPosition.FOOTER);
                if (PluginConfig.instance().get("general", "waila.cfg.shiftblock", false) && !this.currenttipBody.isEmpty() && !accessor.getPlayer().isSneaking()) {
                    this.currenttipBody.clear();
                    this.currenttipBody.add("\u00a7oPress shift for more data");
                }
                this.currenttip.addAll(this.currenttipHead);
                this.currenttip.addAll(this.currenttipBody);
                this.currenttip.addAll(this.currenttipTail);
                this.tooltip = new Tooltip(this.currenttip, targetStack, true);
            }
        } else if (target != null && target.typeOfHit == EnumMovingObjectType.ENTITY) {
            DataAccessorCommon accessor = DataAccessorCommon.INSTANCE;
            accessor.set((World)world, (EntityPlayer)player, target);
            Entity targetEnt = RayTracing.instance().getTargetEntity();
            if (targetEnt != null) {
                this.currenttip.clear();
                this.currenttipHead.clear();
                this.currenttipBody.clear();
                this.currenttipTail.clear();
                this.handler.handleEntityTextData(targetEnt, accessor, this.currenttipHead, TooltipPosition.HEADER);
                this.handler.handleEntityTextData(targetEnt, accessor, this.currenttipBody, TooltipPosition.BODY);
                this.handler.handleEntityTextData(targetEnt, accessor, this.currenttipTail, TooltipPosition.FOOTER);
                if (PluginConfig.instance().get("general", "waila.cfg.shiftents", false) && !this.currenttipBody.isEmpty() && !accessor.getPlayer().isSneaking()) {
                    this.currenttipBody.clear();
                    this.currenttipBody.add("\u00a7oPress shift for more data");
                }
                this.currenttip.addAll(this.currenttipHead);
                this.currenttip.addAll(this.currenttipBody);
                this.currenttip.addAll(this.currenttipTail);
                this.tooltip = new Tooltip(this.currenttip, RayTracing.instance().getTargetStack());
            }
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.CLIENT, TickType.RENDER);
    }

    public String getLabel() {
        return "mod_BlockHelper:WailaTickHandler";
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.isRemote) {
            this.resetAll();
        }
    }

    private void resetAll() {
        this.tooltip = null;
        RayTracing.instance().clear();
        DataAccessorCommon.INSTANCE.clear();
    }
}

