/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.bc3;

import mcp.mobius.waila.addons.bc3.BC3Plugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerBC3Energy
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerBC3Energy();

    private HUDHandlerBC3Energy() {
    }

    @Override
    public rj getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(rj itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(rj itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (!config.get("bcapi.storage")) {
            return;
        }
        if (!accessor.getNBTData().b("MJEnergy")) {
            return;
        }
        int energy = accessor.getNBTInteger("MJEnergy");
        int maxEnergy = accessor.getNBTInteger("MJMaxStorage");
        try {
            if (maxEnergy > 0 && currenttip.getEntries("MJEnergyStorage").isEmpty()) {
                String storedStr = I18n.translate("hud.msg.stored", new Object[0]);
                currenttip.add(storedStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(energy, maxEnergy) + "\u00a7r" + " / " + "\u00a7f" + maxEnergy + "\u00a7r" + " MJ", "MJEnergyStorage");
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(rj itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(aji te, an tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            Object prov;
            Float energy = Float.valueOf(-1.0f);
            Integer maxsto = -1;
            if (BC3Plugin.TileEngine.isInstance(te)) {
                Object engine = BC3Plugin.TileEngine_engine.get(te);
                if (engine != null) {
                    energy = Float.valueOf(BC3Plugin.Engine_energy.getFloat(engine));
                    maxsto = BC3Plugin.Engine_maxEnergy.getInt(engine);
                }
            } else if (BC3Plugin.IPowerReceptor.isInstance(te) && (prov = BC3Plugin.IPowerReceptor_getPowerProvider.invoke((Object)te, new Object[0])) != null) {
                energy = (Float)BC3Plugin.IPowerProvider_getEnergyStored.invoke(prov, new Object[0]);
                maxsto = (Integer)BC3Plugin.IPowerProvider_getMaxEnergyStored.invoke(prov, new Object[0]);
            }
            tag.a("MJEnergy", Math.round(energy.floatValue()));
            tag.a("MJMaxStorage", maxsto.intValue());
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

