/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.bc3;

import mcp.mobius.waila.addons.bc3.BC3Plugin;
import mcp.mobius.waila.addons.bc3.LiquidHelper;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerBC3Tanks
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerBC3Tanks();

    private HUDHandlerBC3Tanks() {
    }

    @Override
    public rj getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(rj itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        try {
            if (config.get("bc.tanktype")) {
                Object stack = null;
                int capacity = 0;
                if (BC3Plugin.ITankContainer.isInstance(accessor.getTileEntity())) {
                    an compound = accessor.getNBTData();
                    stack = compound.b("liquidstack") ? BC3Plugin.LiquidStack_loadLiquidStackFromNBT.invoke(null, compound.l("liquidstack")) : null;
                    capacity = accessor.getNBTInteger("liquidcapacity");
                } else if (accessor.getBlock() == aig.bG) {
                    int meta = accessor.getMetadata();
                    stack = meta == 0 ? null : BC3Plugin.LiquidStack_init.newInstance(aig.B, Math.min(4, meta) * 250);
                    capacity = 1000;
                }
                if (capacity > 0) {
                    String name = (String)currenttip.get(0);
                    name = name + " " + (stack == null ? I18n.translate("hud.msg.empty", new Object[0]) : "(" + LiquidHelper.getLiquidName(stack) + "\u00a7r" + "\u00a7f" + ")");
                    currenttip.set(0, name);
                }
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyBody(rj itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        try {
            if (config.get("bc.tankamount")) {
                int liquidAmount = 0;
                int capacity = 0;
                if (BC3Plugin.ITankContainer.isInstance(accessor.getTileEntity())) {
                    an compound = accessor.getNBTData();
                    Object stack = compound.b("liquidstack") ? BC3Plugin.LiquidStack_loadLiquidStackFromNBT.invoke(null, compound.l("liquidstack")) : null;
                    liquidAmount = stack != null ? BC3Plugin.LiquidStack_amount.getInt(stack) : 0;
                    capacity = accessor.getNBTInteger("liquidcapacity");
                } else if (accessor.getBlock() == aig.bG) {
                    liquidAmount = Math.min(4, accessor.getMetadata()) * 250;
                    capacity = 1000;
                }
                if (capacity > 0) {
                    currenttip.add(liquidAmount + "/" + capacity + " mB");
                }
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(rj itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(aji te, an tag, IServerDataAccessor accessor, IPluginConfig config) {
        LiquidHelper.writeToNBT(te, tag);
    }
}

