/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;

public final class HUDHandlerVanilla
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerVanilla();
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};

    private HUDHandlerVanilla() {
    }

    @Override
    public rj getStack(IDataAccessor accessor, IPluginConfig config) {
        aig block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == VanillaPlugin.silverfish && config.get("vanilla.silverfish")) {
            switch (meta) {
                case 1: {
                    return new rj(aig.w);
                }
                case 2: {
                    return new rj(aig.bm);
                }
            }
            return new rj(aig.t);
        }
        if (block == VanillaPlugin.redstone) {
            return new rj(rh.aC);
        }
        if (block instanceof ahm) {
            return new rj(aig.aN);
        }
        if (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv) {
            return new rj(rh.bb);
        }
        if (block == VanillaPlugin.melonStem) {
            return new rj(rh.bh);
        }
        if (block == VanillaPlugin.pumpkinStem) {
            return new rj(rh.bg);
        }
        if (block == VanillaPlugin.sugarCane) {
            return new rj(rh.aJ);
        }
        if (block == VanillaPlugin.crops) {
            return new rj(rh.T);
        }
        if (block == VanillaPlugin.cauldron) {
            return new rj(rh.bz);
        }
        if (block == VanillaPlugin.bed) {
            return new rj(rh.ba);
        }
        if (block == VanillaPlugin.leave && meta > 3) {
            return new rj(block, 1, meta - 4);
        }
        if (block == VanillaPlugin.log) {
            return new rj(block, 1, meta % 4);
        }
        return null;
    }

    @Override
    public void modifyHead(rj itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        aig block = accessor.getBlock();
        if (block == VanillaPlugin.mobSpawner && accessor.getTileEntity() instanceof aje && config.get("vanilla.spawntype")) {
            String name = (String)currenttip.get(0);
            String mobname = ((aje)accessor.getTileEntity()).a();
            currenttip.set(0, name + " (" + mobname + ")");
        }
        if (block == VanillaPlugin.melonStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.melonStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.pumpkinStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pumpkinStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.endPortal) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.endPortal.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonExtension) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonExtension.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonMoving) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonMoving.name", new Object[0]));
        }
    }

    @Override
    public void modifyBody(rj itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        aig block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (config.get("vanilla.leverstate") && block == VanillaPlugin.lever) {
            String redstoneOn = (meta & 8) == 0 ? I18n.translate("hud.msg.off", new Object[0]) : I18n.translate("hud.msg.on", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + redstoneOn);
        }
        if (config.get("vanilla.repeater") && (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv)) {
            int tick = ((meta & 0xC) >> 2) + 1;
            if (tick == 1) {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": 1 tick");
            } else {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": " + tick + " ticks");
            }
        }
        if (config.get("vanilla.redstone") && block == VanillaPlugin.redstone) {
            currenttip.add(I18n.translate("hud.msg.power", new Object[0]) + ": " + meta);
        }
        if (config.get("vanilla.jukebox") && block == VanillaPlugin.jukebox) {
            an tag = accessor.getNBTData();
            rh record = null;
            if (tag.b("RecordItem")) {
                rj stack = rj.a((an)tag.l("RecordItem"));
                rh rh2 = record = stack == null ? null : stack.b();
            }
            if (record == null && tag.b("Record")) {
                record = rh.e[accessor.getNBTInteger(tag, "Record")];
            }
            currenttip.add(record == null ? I18n.translate("hud.msg.empty", new Object[0]) : I18n.translate("hud.msg.record", new Object[0]) + ": " + "C418 - " + ((ru)record).a);
        }
        if (config.get("vanilla.noteblock") && block == VanillaPlugin.noteBlock) {
            int note = accessor.getNBTInteger("note");
            currenttip.add(I18n.translate("hud.msg.note", new Object[0]) + ": " + NOTES[note % 12] + (note / 12 + 1));
            ajq mop = accessor.getPosition();
            aco m = accessor.getWorld().f(mop.b, mop.c - 1, mop.d);
            String instrument = "hud.msg.piano";
            if (m == aco.e) {
                instrument = "hud.msg.bass_drum";
            } else if (m == aco.o) {
                instrument = "hud.msg.snare_drum";
            } else if (m == aco.q) {
                instrument = "hud.msg.clicks_sticks";
            } else if (m == aco.d) {
                instrument = "hud.msg.bass_guitar";
            }
            currenttip.add(I18n.translate("hud.msg.instrument", new Object[0]) + ": " + I18n.translate(instrument, new Object[0]));
        }
    }

    @Override
    public void modifyTail(rj itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(aji te, an tag, IServerDataAccessor accessor, IPluginConfig config) {
    }
}

