/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.WailaDirection;
import mcp.mobius.waila.utils.NBTUtil;

public class DataAccessorCommon
implements ICommonAccessor,
IDataAccessor,
IEntityAccessor {
    public up world;
    public og player;
    public ajq mop;
    public ajs renderingvec = null;
    public aig block;
    public int blockID;
    public int metadata;
    public aji tileEntity;
    public jn entity;
    public an remoteNbt = new an();
    public long timeLastUpdate = System.currentTimeMillis();
    public double partialFrame;
    public rj stack;
    public static final DataAccessorCommon INSTANCE = new DataAccessorCommon();

    public void set(up _world, og _player, ajq _mop) {
        this.set(_world, _player, _mop, null, 0.0);
    }

    public void set(up _world, og _player, ajq _mop, jw viewEntity, double partialTicks) {
        this.world = _world;
        this.player = _player;
        this.mop = _mop;
        if (this.mop == null) {
            this.renderingvec = null;
            this.block = null;
            this.blockID = 0;
            this.metadata = 0;
            this.tileEntity = null;
            this.entity = null;
            this.remoteNbt = new an();
            this.timeLastUpdate = System.currentTimeMillis();
            this.partialFrame = 0.0;
            this.stack = null;
        } else {
            if (this.mop.a == ajr.a) {
                this.blockID = this.world.a(this.mop.b, this.mop.c, this.mop.d);
                this.metadata = this.world.g(this.mop.b, this.mop.c, this.mop.d);
                this.block = aig.m[this.blockID];
                this.tileEntity = this.world.p(this.mop.b, this.mop.c, this.mop.d);
                this.entity = null;
                try {
                    this.stack = new rj(this.block, 1, this.metadata);
                }
                catch (Throwable ignored) {}
            } else if (this.mop.a == ajr.b) {
                this.block = null;
                this.metadata = -1;
                this.tileEntity = null;
                this.stack = null;
                this.entity = this.mop.g;
            }
            if (viewEntity != null) {
                double px = viewEntity.S + (viewEntity.t - viewEntity.S) * partialTicks;
                double py = viewEntity.T + (viewEntity.u - viewEntity.T) * partialTicks;
                double pz = viewEntity.U + (viewEntity.v - viewEntity.U) * partialTicks;
                this.renderingvec = ajs.a((double)((double)this.mop.b - px), (double)((double)this.mop.c - py), (double)((double)this.mop.d - pz));
                this.partialFrame = partialTicks;
            }
        }
    }

    public void clear() {
        this.set(null, null, null);
    }

    @Override
    public up getWorld() {
        return this.world;
    }

    @Override
    public og getPlayer() {
        return this.player;
    }

    @Override
    public aig getBlock() {
        return this.block;
    }

    @Override
    public int getBlockID() {
        return this.blockID;
    }

    @Override
    public int getMetadata() {
        return this.metadata;
    }

    @Override
    public aji getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public jn getEntity() {
        return this.entity;
    }

    @Override
    public ajq getPosition() {
        return this.mop;
    }

    @Override
    public ajs getRenderingPosition() {
        return this.renderingvec;
    }

    @Override
    public an getNBTData() {
        if (this.tileEntity != null && this.isTagCorrectTileEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.entity != null && this.isTagCorrectEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.tileEntity != null) {
            an tag = new an();
            try {
                this.tileEntity.b(tag);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            return tag;
        }
        if (this.entity != null) {
            an tag = new an();
            try {
                this.entity.d(tag);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return tag;
        }
        return new an();
    }

    public void setNBTData(an tag) {
        if (tag != null) {
            this.remoteNbt = tag;
        }
    }

    private boolean isTagCorrectTileEntity(an tag) {
        if (!(tag != null && tag.b("WailaX") && tag.b("WailaY") && tag.b("WailaZ"))) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.e("WailaX");
        int y = tag.e("WailaY");
        int z = tag.e("WailaZ");
        if (x == this.mop.b && y == this.mop.c && z == this.mop.d) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity(an tag) {
        if (tag == null || !tag.b("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.e("WailaEntityID");
        if (id == this.entity.k) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    @Override
    public int getNBTInteger(String keyname) {
        return this.getNBTInteger(this.getNBTData(), keyname);
    }

    @Override
    public int getNBTInteger(an tag, String keyname) {
        return NBTUtil.getNBTInteger(tag, keyname);
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    @Override
    public WailaDirection getSide() {
        return WailaDirection.getOrientation(this.getPosition().e);
    }

    @Override
    public rj getStack() {
        return this.stack;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

