/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.overlay.tooltiprenderers.TTRenderIcon;
import mcp.mobius.waila.overlay.tooltiprenderers.TTRenderString;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;

public class Tooltip {
    public static final int TabSpacing = 8;
    public static final int IconSize = 8;
    final List<List<String>> lines = new ArrayList<List<String>>();
    final List<List<Integer>> sizes = new ArrayList<List<Integer>>();
    final List<Integer> columnsWidth = new ArrayList<Integer>();
    final List<Integer> columnsPos = new ArrayList<Integer>();
    final List<Renderable> elements = new ArrayList<Renderable>();
    final List<Renderable> elements2nd = new ArrayList<Renderable>();
    Rectangle pos;
    int offsetX;
    int offsetY;
    int maxStringW;
    boolean hasIcon = false;
    rj stack;
    static final ICommonAccessor accessor = DataAccessorCommon.INSTANCE;

    public Tooltip(ITaggedList<String, String> textData, rj stack) {
        this(textData, stack, stack != null);
    }

    public Tooltip(ITaggedList<String, String> textData, rj stack, boolean hasIcon) {
        WailaTooltipEvent event = new WailaTooltipEvent(textData, DataAccessorCommon.INSTANCE);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.stack = stack;
        if (hasIcon) {
            hasIcon = PluginConfig.instance().showIcon();
        }
        this.columnsWidth.add(0);
        this.columnsPos.add(0);
        for (String s : textData) {
            ArrayList<String> line = new ArrayList<String>(Arrays.asList(SpecialChars.patternTab.split(s)));
            ArrayList<Integer> size = new ArrayList<Integer>();
            for (String ss : line) {
                size.add(DisplayUtil.getDisplayWidth(ss));
            }
            if (line.size() > 1) {
                while (this.columnsWidth.size() < line.size()) {
                    this.columnsWidth.add(0);
                    this.columnsPos.add(0);
                }
                for (int i = 0; i < line.size(); ++i) {
                    this.columnsWidth.set(i, Math.max(this.columnsWidth.get(i), (Integer)size.get(i)));
                }
            }
            this.maxStringW = Math.max(this.maxStringW, DisplayUtil.getDisplayWidth(s) + 8 * (line.size() - 1));
            this.lines.add(line);
            this.sizes.add(size);
        }
        if (this.columnsWidth.size() == 1) {
            this.columnsWidth.set(0, this.maxStringW);
        }
        int tmp = 0;
        for (int i = 0; i < this.columnsWidth.size(); ++i) {
            tmp += this.columnsWidth.get(i).intValue();
            if (i == 0) continue;
            this.columnsPos.set(i, this.columnsWidth.get(i - 1) + this.columnsPos.get(i - 1) + 8);
        }
        this.maxStringW = Math.max(this.maxStringW, tmp += 8 * (this.columnsWidth.size() - 1));
        this.computeRenderables();
        this.computePositionAndSize(hasIcon);
    }

    private void computeRenderables() {
        int offsetY = 0;
        for (List<String> line : this.lines) {
            int maxHeight = 0;
            for (int c = 0; c < line.size(); ++c) {
                this.offsetX = this.columnsPos.get(c);
                String currentLine = line.get(c);
                Matcher lineMatcher = SpecialChars.patternLineSplit.matcher(currentLine);
                while (lineMatcher.find()) {
                    String cs2 = lineMatcher.group();
                    Renderable renderable = null;
                    Matcher renderMatcher = SpecialChars.patternRender.matcher(cs2);
                    Matcher iconMatcher = SpecialChars.patternIcon.matcher(cs2);
                    if (renderMatcher.find()) {
                        String renderName = renderMatcher.group(1);
                        ITooltipRenderer renderer = WailaRegistrar.instance().getTooltipRenderer(renderName);
                        if (renderer != null) {
                            renderable = new Renderable(renderer, new Point(this.offsetX, offsetY), renderMatcher.group(2).split(","));
                            this.elements2nd.add(renderable);
                        }
                    } else if (iconMatcher.find()) {
                        renderable = new Renderable(new TTRenderIcon(), new Point(this.offsetX, offsetY), iconMatcher.group(1));
                        this.elements2nd.add(renderable);
                    } else {
                        if (cs2.startsWith("\u00a4\u00a4b")) {
                            this.offsetX += this.columnsWidth.get(c) - DisplayUtil.getDisplayWidth(currentLine.substring(lineMatcher.start()));
                        }
                        if (cs2.startsWith("\u00a4\u00a4c")) {
                            this.offsetX += (this.columnsWidth.get(c) - DisplayUtil.getDisplayWidth(currentLine.substring(lineMatcher.start()))) / 2;
                        }
                        renderable = new Renderable(new TTRenderString(), new Point(this.offsetX, offsetY), DisplayUtil.stripWailaSymbols(cs2));
                        this.elements.add(renderable);
                    }
                    if (renderable == null) continue;
                    this.offsetX += renderable.getSize(accessor).getWidth();
                    maxHeight = Math.max(maxHeight, renderable.getSize(accessor).getHeight() + 2);
                }
            }
            offsetY += maxHeight;
        }
    }

    private int getRenderableTotalHeight() {
        int result = 0;
        for (Renderable r : this.elements) {
            result = Math.max(r.getPos().getY() + r.getSize(accessor).getHeight() + 2, result);
        }
        return result;
    }

    private void computePositionAndSize(boolean hasIcon) {
        int x = PluginConfig.instance().get("general", "waila.cfg.posx", 0);
        int y = PluginConfig.instance().get("general", "waila.cfg.posy", 0);
        this.hasIcon = hasIcon;
        int paddingW = hasIcon ? 29 : 13;
        int paddingH = hasIcon ? 24 : 0;
        int w = this.maxStringW + paddingW;
        int h = Math.max(paddingH, this.getRenderableTotalHeight() + 8);
        Dimension size = DisplayUtil.displaySize();
        x = ((int)((float)size.getWidth() / OverlayConfig.scale) - w - 1) * x / 10000;
        y = ((int)((float)size.getHeight() / OverlayConfig.scale) - h - 1) * y / 10000;
        this.pos = new Rectangle(x, y, w, h);
        this.offsetX = hasIcon ? 24 : 6;
        this.offsetY = (h - this.getRenderableTotalHeight()) / 2 + 1;
    }

    public boolean hasItem() {
        return this.hasIcon && this.stack != null && this.stack.b() != null;
    }

    public void drawAll() {
        this.draw();
        this.draw2nd();
    }

    public void draw() {
        for (Renderable r : this.elements) {
            r.draw(accessor, this.pos.getX() + this.offsetX, this.pos.getY() + this.offsetY);
        }
    }

    public void draw2nd() {
        for (Renderable r : this.elements2nd) {
            r.draw(accessor, this.pos.getX() + this.offsetX, this.pos.getY() + this.offsetY);
        }
    }

    private static class Renderable {
        final ITooltipRenderer renderer;
        final Point pos;
        final String[] params;

        public Renderable(ITooltipRenderer renderer, Point pos, String ... params) {
            this.renderer = renderer;
            this.pos = pos;
            this.params = params;
        }

        public Point getPos() {
            return this.pos;
        }

        public Dimension getSize(ICommonAccessor accessor) {
            Dimension dim = new Dimension(0, 0);
            try {
                dim = this.renderer.getSize(this.params, accessor);
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, this.renderer.getClass().getName() + ".getSize()", null);
            }
            return dim;
        }

        public void draw(ICommonAccessor accessor, int x, int y) {
            GL11.glPushMatrix();
            try {
                this.renderer.draw(this.params, accessor, this.pos.getX() + x, this.pos.getY() + y);
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, this.renderer.getClass().getName() + ".draw()", null);
            }
            GL11.glPopMatrix();
        }

        public String toString() {
            return "Renderable@[" + this.pos.getX() + "," + this.pos.getY() + "] | " + this.renderer;
        }
    }
}

