/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;

public final class ModIdentification {
    public static final String MINECRAFT = "Minecraft";
    private static final Map<Object, String> classToMod = new HashMap<Object, String>();
    private static Set<ModInfo> modInfos;

    private ModIdentification() {
        throw new UnsupportedOperationException();
    }

    public static void init() {
        modInfos = new HashSet<ModInfo>();
        String minecraftUri = new File("bin/minecraft.jar").getAbsoluteFile().toString();
        try {
            minecraftUri = ModIdentification.formatURI(Minecraft.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Throwable t) {
            mod_BlockHelper.LOG.log(Level.WARNING, "ModIdentification#init", t);
        }
        modInfos.add(new ModInfo(minecraftUri, MINECRAFT));
        try {
            block6: for (ModContainer container : Loader.instance().getModList()) {
                try {
                    File source = container.getSource();
                    if (!source.isFile()) continue;
                    String uri = ModIdentification.formatURI(source.toURI());
                    for (ModInfo info : modInfos) {
                        if (!info.uri.equals(uri)) continue;
                        continue block6;
                    }
                    modInfos.add(new ModInfo(uri, ModIdentification.getModName(container)));
                }
                catch (Throwable t) {
                    mod_BlockHelper.LOG.log(Level.WARNING, "ModIdentification#init", t);
                }
            }
        }
        catch (Throwable t) {
            mod_BlockHelper.LOG.log(Level.WARNING, "ModIdentification#init", t);
        }
    }

    public static String identifyMod(Object object) {
        if (object instanceof rj) {
            object = ((rj)object).b();
        }
        if (object instanceof si) {
            object = aig.m[((si)object).f()];
        }
        if (object == null) {
            return "";
        }
        Class<?> clazz = object.getClass();
        String mod = classToMod.get(clazz);
        if (mod != null) {
            return mod;
        }
        mod = ModIdentification.lookupMod(clazz);
        if (mod != null) {
            classToMod.put(clazz, mod);
            return mod;
        }
        classToMod.put(clazz, MINECRAFT);
        return MINECRAFT;
    }

    private static String lookupMod(Class<?> clazz) {
        try {
            String modFile = ModIdentification.formatURI(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
            for (ModInfo modInfo : modInfos) {
                if (!modFile.contains(modInfo.uri)) continue;
                return modInfo.name;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String getModName(ModContainer container) {
        if (container != null) {
            ModMetadata metadata = container.getMetadata();
            if (metadata != null && metadata.name != null) {
                return ModIdentification.formatModName(metadata.name);
            }
            return ModIdentification.formatModName(container.getName());
        }
        return MINECRAFT;
    }

    private static String formatModName(String name) {
        return name == null ? MINECRAFT : name.replaceFirst("^mod_", "").replaceAll("\u00c2\u00a7.", "").replaceAll("\u00a7.", "");
    }

    private static String formatURI(URI uri) {
        String uriStr = uri.toString();
        try {
            JarURLConnection connection = (JarURLConnection)uri.toURL().openConnection();
            uriStr = connection.getJarFileURL().toURI().toString();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            uriStr = URLDecoder.decode(uriStr, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return uriStr;
    }

    private static class ModInfo {
        private final String uri;
        private final String name;

        private ModInfo(String uri, String name) {
            this.uri = uri;
            this.name = name;
        }
    }
}

