/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.src.Block;
import net.minecraft.src.BlockRedstoneOre;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityMobSpawner;

public final class HUDHandlerVanilla
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerVanilla();
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};

    private HUDHandlerVanilla() {
    }

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == VanillaPlugin.redstone) {
            return new ItemStack(Item.redstone);
        }
        if (block instanceof BlockRedstoneOre) {
            return new ItemStack(Block.oreRedstone);
        }
        if (block == VanillaPlugin.sugarCane) {
            return new ItemStack(Item.reed);
        }
        if (block == VanillaPlugin.crops) {
            return new ItemStack(Item.wheat);
        }
        if (block == VanillaPlugin.leave && meta > 3) {
            return new ItemStack(block, 1, meta - 4);
        }
        if (block == VanillaPlugin.log) {
            return new ItemStack(block, 1, meta % 4);
        }
        return null;
    }

    @Override
    public void modifyHead(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        if (block == VanillaPlugin.mobSpawner && accessor.getTileEntity() instanceof TileEntityMobSpawner && config.get("vanilla.spawntype")) {
            String name = (String)currenttip.get(0);
            String mobname = ((TileEntityMobSpawner)accessor.getTileEntity()).getMobID();
            currenttip.set(0, name + " (" + mobname + ")");
        }
    }

    @Override
    public void modifyBody(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (config.get("vanilla.leverstate") && block == VanillaPlugin.lever) {
            String redstoneOn = (meta & 8) == 0 ? I18n.translate("hud.msg.off", new Object[0]) : I18n.translate("hud.msg.on", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + redstoneOn);
        }
        if (config.get("vanilla.redstone") && block == VanillaPlugin.redstone) {
            currenttip.add(I18n.translate("hud.msg.power", new Object[0]) + ": " + meta);
        }
        if (config.get("vanilla.jukebox") && block == VanillaPlugin.jukebox) {
            NBTTagCompound tag = accessor.getNBTData();
            Item record = null;
            if (meta != 0) {
                record = Item.itemsList[Item.record13.shiftedIndex + meta - 1];
            }
            try {
                currenttip.add(record == null ? I18n.translate("hud.msg.empty", new Object[0]) : I18n.translate("hud.msg.record", new Object[0]) + ": " + "C418 - " + VanillaPlugin.ItemRecord_recordName.get(record));
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, block.getClass().getName() + ":" + meta, currenttip);
            }
        }
        if (config.get("vanilla.noteblock") && block == VanillaPlugin.noteBlock) {
            int note = accessor.getNBTInteger("note");
            currenttip.add(I18n.translate("hud.msg.note", new Object[0]) + ": " + NOTES[note % 12] + (note / 12 + 1));
            MovingObjectPosition mop = accessor.getPosition();
            Material m = accessor.getWorld().getBlockMaterial(mop.blockX, mop.blockY - 1, mop.blockZ);
            String instrument = "hud.msg.piano";
            if (m == Material.rock) {
                instrument = "hud.msg.bass_drum";
            } else if (m == Material.sand) {
                instrument = "hud.msg.snare_drum";
            } else if (m == Material.glass) {
                instrument = "hud.msg.clicks_sticks";
            } else if (m == Material.wood) {
                instrument = "hud.msg.bass_guitar";
            }
            currenttip.add(I18n.translate("hud.msg.instrument", new Object[0]) + ": " + I18n.translate(instrument, new Object[0]));
        }
    }

    @Override
    public void modifyTail(ItemStack itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(TileEntity te, NBTTagCompound tag, IServerDataAccessor accessor, IPluginConfig config) {
    }
}

