/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic;

import java.lang.reflect.Field;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public class HUDHandlerICCharge
implements IDataProvider {
    private final Field currCharge;
    private final Field maxCharge;

    public HUDHandlerICCharge(Field currCharge, Field maxCharge) {
        this.currCharge = currCharge;
        this.maxCharge = maxCharge;
    }

    @Override
    public gm getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(gm itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(gm itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get("ic.storage")) {
            try {
                int storage = accessor.getNBTInteger("storage");
                int maxStorage = accessor.getNBTInteger("maxStorage");
                String storedStr = I18n.translate("hud.msg.stored", new Object[0]);
                currenttip.add(storedStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(storage, maxStorage) + (maxStorage > 0 ? "\u00a7r / \u00a7f" + maxStorage : "") + "\u00a7r" + " EU");
            }
            catch (Throwable t) {
                WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
            }
        }
    }

    @Override
    public void modifyTail(gm itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(kp te, jw tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            tag.a("storage", this.currCharge.getInt(te));
            if (this.maxCharge != null) {
                tag.a("maxStorage", this.maxCharge.getInt(te));
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), null);
        }
    }
}

