/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.WailaDirection;
import mcp.mobius.waila.utils.NBTUtil;

public class DataAccessorCommon
implements ICommonAccessor,
IDataAccessor,
IEntityAccessor {
    public dn world;
    public eu player;
    public pr mop;
    public ax renderingvec = null;
    public pj block;
    public int blockID;
    public int metadata;
    public kp tileEntity;
    public nl entity;
    public jw remoteNbt = new jw();
    public long timeLastUpdate = System.currentTimeMillis();
    public double partialFrame;
    public gm stack;
    public static final DataAccessorCommon INSTANCE = new DataAccessorCommon();

    public void set(dn _world, eu _player, pr _mop) {
        this.set(_world, _player, _mop, null, 0.0);
    }

    public void set(dn _world, eu _player, pr _mop, ig viewEntity, double partialTicks) {
        this.world = _world;
        this.player = _player;
        this.mop = _mop;
        if (this.mop == null) {
            this.renderingvec = null;
            this.block = null;
            this.blockID = 0;
            this.metadata = 0;
            this.tileEntity = null;
            this.entity = null;
            this.remoteNbt = new jw();
            this.timeLastUpdate = System.currentTimeMillis();
            this.partialFrame = 0.0;
            this.stack = null;
        } else {
            if (this.mop.a == gq.a) {
                this.blockID = this.world.a(this.mop.b, this.mop.c, this.mop.d);
                this.metadata = this.world.e(this.mop.b, this.mop.c, this.mop.d);
                this.block = pj.m[this.blockID];
                this.tileEntity = this.world.b(this.mop.b, this.mop.c, this.mop.d);
                this.entity = null;
                try {
                    this.stack = new gm(this.block, 1, this.metadata);
                }
                catch (Throwable ignored) {}
            } else if (this.mop.a == gq.b) {
                this.block = null;
                this.metadata = -1;
                this.tileEntity = null;
                this.stack = null;
                this.entity = this.mop.g;
            }
            if (viewEntity != null) {
                double px = viewEntity.be + (viewEntity.aF - viewEntity.be) * partialTicks;
                double py = viewEntity.bf + (viewEntity.aG - viewEntity.bf) * partialTicks;
                double pz = viewEntity.bg + (viewEntity.aH - viewEntity.bg) * partialTicks;
                this.renderingvec = ax.a((double)((double)this.mop.b - px), (double)((double)this.mop.c - py), (double)((double)this.mop.d - pz));
                this.partialFrame = partialTicks;
            }
        }
    }

    public void clear() {
        this.set(null, null, null);
    }

    @Override
    public dn getWorld() {
        return this.world;
    }

    @Override
    public eu getPlayer() {
        return this.player;
    }

    @Override
    public pj getBlock() {
        return this.block;
    }

    @Override
    public int getBlockID() {
        return this.blockID;
    }

    @Override
    public int getMetadata() {
        return this.metadata;
    }

    @Override
    public kp getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public nl getEntity() {
        return this.entity;
    }

    @Override
    public pr getPosition() {
        return this.mop;
    }

    @Override
    public ax getRenderingPosition() {
        return this.renderingvec;
    }

    @Override
    public jw getNBTData() {
        if (this.tileEntity != null && this.isTagCorrectTileEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.entity != null && this.isTagCorrectEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.tileEntity != null) {
            jw tag = new jw();
            try {
                this.tileEntity.b(tag);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            return tag;
        }
        if (this.entity != null) {
            jw tag = new jw();
            try {
                this.entity.d(tag);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return tag;
        }
        return new jw();
    }

    public void setNBTData(jw tag) {
        if (tag != null) {
            this.remoteNbt = tag;
        }
    }

    private boolean isTagCorrectTileEntity(jw tag) {
        if (!(tag != null && tag.b("WailaX") && tag.b("WailaY") && tag.b("WailaZ"))) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.e("WailaX");
        int y = tag.e("WailaY");
        int z = tag.e("WailaZ");
        if (x == this.mop.b && y == this.mop.c && z == this.mop.d) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity(jw tag) {
        if (tag == null || !tag.b("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.e("WailaEntityID");
        if (id == this.entity.aw) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    @Override
    public int getNBTInteger(String keyname) {
        return this.getNBTInteger(this.getNBTData(), keyname);
    }

    @Override
    public int getNBTInteger(jw tag, String keyname) {
        return NBTUtil.getNBTInteger(tag, keyname);
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    @Override
    public WailaDirection getSide() {
        return WailaDirection.getOrientation(this.getPosition().e);
    }

    @Override
    public gm getStack() {
        return this.stack;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

