/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.event.ClientFirstTickInWorldEvent;
import mcp.mobius.waila.api.event.WailaEventRegistrar;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.MetaDataProvider;
import mcp.mobius.waila.api.impl.PluginConfig;
import mcp.mobius.waila.api.impl.TipList;
import mcp.mobius.waila.network.Packet0x00ServerPing;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.utils.FixDetector;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.client.Minecraft;

public class WailaTickHandler {
    private Tooltip tooltip;
    private final MetaDataProvider handler = new MetaDataProvider();
    private final ITaggedList<String, String> currenttip = new TipList<String, String>();
    private final ITaggedList<String, String> currenttipHead = new TipList<String, String>();
    private final ITaggedList<String, String> currenttipBody = new TipList<String, String>();
    private final ITaggedList<String, String> currenttipTail = new TipList<String, String>();
    private boolean firstTick = true;
    private dn lastWorld = null;

    public void onTickInGame(Minecraft mc) {
        dn world = mc.e;
        bz player = mc.g;
        this.resetAllWhenNeeded(mc);
        if (world == null || player == null) {
            return;
        }
        if (this.firstTick) {
            ModIdentification.init();
            FixDetector.detectFixes(mc);
            mod_BlockHelper.UPDATER.notifyUpdater(mc);
            WailaEventRegistrar.postClientFirstTickInWorld(new ClientFirstTickInWorldEvent(mc));
            this.firstTick = false;
        }
        if (!mc.j()) {
            mod_BlockHelper.INSTANCE.serverPresent = true;
        }
        RayTracing.instance().fire();
        pr target = RayTracing.instance().getTarget();
        if (target != null && target.a == gq.a) {
            DataAccessorCommon accessor = DataAccessorCommon.INSTANCE;
            accessor.set(world, (eu)player, target);
            gm targetStack = RayTracing.instance().getTargetStack();
            if (targetStack != null) {
                this.currenttip.clear();
                this.currenttipHead.clear();
                this.currenttipBody.clear();
                this.currenttipTail.clear();
                this.handler.handleBlockTextData(targetStack, accessor, this.currenttipHead, TooltipPosition.HEADER);
                this.handler.handleBlockTextData(targetStack, accessor, this.currenttipBody, TooltipPosition.BODY);
                this.handler.handleBlockTextData(targetStack, accessor, this.currenttipTail, TooltipPosition.FOOTER);
                if (PluginConfig.instance().get("general", "waila.cfg.shiftblock", false) && !this.currenttipBody.isEmpty() && !accessor.getPlayer().s()) {
                    this.currenttipBody.clear();
                    this.currenttipBody.add("\u00a7oPress shift for more data");
                }
                this.currenttip.addAll(this.currenttipHead);
                this.currenttip.addAll(this.currenttipBody);
                this.currenttip.addAll(this.currenttipTail);
                this.tooltip = new Tooltip(this.currenttip, targetStack, true);
            }
        } else if (target != null && target.a == gq.b) {
            DataAccessorCommon accessor = DataAccessorCommon.INSTANCE;
            accessor.set(world, (eu)player, target);
            nl targetEnt = RayTracing.instance().getTargetEntity();
            if (targetEnt != null) {
                this.currenttip.clear();
                this.currenttipHead.clear();
                this.currenttipBody.clear();
                this.currenttipTail.clear();
                this.handler.handleEntityTextData(targetEnt, accessor, this.currenttipHead, TooltipPosition.HEADER);
                this.handler.handleEntityTextData(targetEnt, accessor, this.currenttipBody, TooltipPosition.BODY);
                this.handler.handleEntityTextData(targetEnt, accessor, this.currenttipTail, TooltipPosition.FOOTER);
                if (PluginConfig.instance().get("general", "waila.cfg.shiftents", false) && !this.currenttipBody.isEmpty() && !accessor.getPlayer().s()) {
                    this.currenttipBody.clear();
                    this.currenttipBody.add("\u00a7oPress shift for more data");
                }
                this.currenttip.addAll(this.currenttipHead);
                this.currenttip.addAll(this.currenttipBody);
                this.currenttip.addAll(this.currenttipTail);
                this.tooltip = new Tooltip(this.currenttip, RayTracing.instance().getTargetStack());
            }
        }
        OverlayRenderer.renderOverlay(this.tooltip);
    }

    private void resetAllWhenNeeded(Minecraft mc) {
        dn world = mc.e;
        if (this.lastWorld != world) {
            this.lastWorld = world;
            this.resetAll();
        }
    }

    private void resetAll() {
        this.tooltip = null;
        RayTracing.instance().clear();
        DataAccessorCommon.INSTANCE.clear();
        Packet0x00ServerPing.resetClient();
    }
}

