/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.src.mod_BlockHelper;

public final class WailaExceptionHandler {
    private static final Set<String> errs = new HashSet<String>();

    private WailaExceptionHandler() {
        throw new UnsupportedOperationException();
    }

    public static void handleErr(Throwable t, Class<?> context) {
        WailaExceptionHandler.handleErr(t, context.getName());
    }

    public static void handleErr(Throwable t, String context) {
        if (!errs.contains(context)) {
            errs.add(context);
            block0: for (Throwable working = t; working != null; working = working.getCause()) {
                if (working != t) {
                    mod_BlockHelper.LOG.log(Level.WARNING, "Caused by: " + working);
                }
                for (StackTraceElement elem : working.getStackTrace()) {
                    mod_BlockHelper.LOG.log(Level.WARNING, elem.getClassName() + "." + elem.getMethodName() + ":" + elem.getLineNumber());
                    if (working == t && elem.getClassName().contains("waila")) continue block0;
                }
            }
            mod_BlockHelper.LOG.log(Level.WARNING, "Caught unhandled exception: [" + context + "] " + t);
        }
    }
}

