/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mcp.mobius.waila.network.IWailaPacket;
import mcp.mobius.waila.network.Packet0x00ServerPing;
import mcp.mobius.waila.network.Packet0x01TileRequest;
import mcp.mobius.waila.network.Packet0x02EntRequest;
import mcp.mobius.waila.network.Packet0x03NBTData;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public class WailaPacketHandler {
    public static final WailaPacketHandler INSTANCE = new WailaPacketHandler();

    private WailaPacketHandler() {
    }

    public void onPacketData(fy source, Packet200ModLoader payload) {
        try {
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(WailaPacketHandler.toByteArray(payload.dataInt)));
            String channel = inputStream.readUTF();
            if (!channel.equals("BlockHelper")) {
                return;
            }
            byte header = WailaPacketHandler.getHeader(inputStream);
            IWailaPacket castedPacket = WailaPacketHandler.getWailaPacket(header);
            if (castedPacket != null) {
                castedPacket.decode(inputStream);
                castedPacket.handleServer(source);
            }
            inputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte getHeader(DataInputStream inputStream) {
        try {
            return inputStream.readByte();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static IWailaPacket getWailaPacket(byte header) {
        if (header == 0) {
            return new Packet0x00ServerPing();
        }
        if (header == 1) {
            return new Packet0x01TileRequest();
        }
        if (header == 2) {
            return new Packet0x02EntRequest();
        }
        if (header == 3) {
            return new Packet0x03NBTData();
        }
        return null;
    }

    public static byte getPacketId(IWailaPacket packet) {
        if (packet instanceof Packet0x00ServerPing) {
            return 0;
        }
        if (packet instanceof Packet0x01TileRequest) {
            return 1;
        }
        if (packet instanceof Packet0x02EntRequest) {
            return 2;
        }
        if (packet instanceof Packet0x03NBTData) {
            return 3;
        }
        return -1;
    }

    public static byte[] toByteArray(int[] arr) {
        byte[] ret = new byte[arr[0]];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(arr[1 + i / 4] >> i % 4 * 8 & 0xFF);
        }
        return ret;
    }

    public static int[] toIntArray(byte[] arr) {
        int[] ret = new int[1 + (arr.length + 3) / 4];
        ret[0] = arr.length;
        for (int i = 0; i < arr.length; ++i) {
            int n = 1 + i / 4;
            ret[n] = ret[n] | (arr[i] & 0xFF) << i % 4 * 8;
        }
        return ret;
    }

    public static Packet200ModLoader wrapMLPacket(IWailaPacket packet) {
        Packet200ModLoader mlPacket = new Packet200ModLoader();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeUTF("BlockHelper");
            outputStream.writeByte(WailaPacketHandler.getPacketId(packet));
            packet.encode(outputStream);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, packet.getClass());
        }
        mlPacket.dataInt = WailaPacketHandler.toIntArray(bos.toByteArray());
        return mlPacket;
    }

    public static void sendPacketToPlayer(IWailaPacket packet, fy player) {
        ModLoader.SendPacketTo((BaseMod)mod_BlockHelper.INSTANCE, (fy)player, (Packet200ModLoader)WailaPacketHandler.wrapMLPacket(packet));
    }

    public static void writeString(String str, DataOutputStream dos) throws IOException {
        if (str.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        dos.writeShort(str.length());
        dos.writeChars(str);
    }

    public static String readString(DataInputStream dis, int maxSize) throws IOException {
        int size = dis.readShort();
        if (size > maxSize) {
            throw new IOException("Received string length longer than maximum allowed (" + size + " > " + maxSize + ")");
        }
        if (size < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append(dis.readChar());
        }
        return builder.toString();
    }
}

