/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic2;

import mcp.mobius.waila.addons.ic2.IC2Plugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerIC2Generator
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerIC2Generator();

    private HUDHandlerIC2Generator() {
    }

    @Override
    public xs getStack(IDataAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public void modifyHead(xs itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void modifyBody(xs itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        try {
            short storage = accessor.getNBTData().e("storage");
            int production = accessor.getNBTData().f("production");
            short maxStorage = accessor.getNBTData().e("maxStorage");
            String storedStr = I18n.translate("hud.msg.stored", new Object[0]);
            String outputStr = I18n.translate("hud.msg.output", new Object[0]);
            if (config.get("ic2.storage") && maxStorage > 0) {
                currenttip.add(storedStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + Math.min(storage, maxStorage) + "\u00a7r" + " / " + "\u00a7f" + maxStorage + "\u00a7r" + " EU");
            }
            if (config.get("ic2.outputeu")) {
                currenttip.add(outputStr + "\u00a4\u00a4a" + "\u00a4\u00a4b" + "\u00a7f" + production + "\u00a7r" + " EU/t");
            }
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, accessor.getTileEntity().getClass(), currenttip);
        }
    }

    @Override
    public void modifyTail(xs itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(js te, aav tag, IServerDataAccessor accessor, IPluginConfig config) {
        try {
            short storage = -1;
            int production = -1;
            short maxStorage = -1;
            if (IC2Plugin.TileBaseGenerator.isInstance(te)) {
                storage = IC2Plugin.TileBaseGenerator_storage.getShort(te);
                production = IC2Plugin.TileBaseGenerator_production.getInt(te);
                maxStorage = IC2Plugin.TileBaseGenerator_maxStorage.getShort(te);
            }
            tag.a("storage", storage);
            tag.a("production", production);
            tag.a("maxStorage", maxStorage);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

