/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import java.util.Random;
import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.ConstantRandom;
import mcp.mobius.waila.utils.I18n;

public final class HUDHandlerVanilla
implements IDataProvider {
    public static final IDataProvider INSTANCE = new HUDHandlerVanilla();
    private static final String[] NOTES = new String[]{"F\u266f/G\u266d", "G", "G\u266f/A\u266d", "A", "A\u266f/B\u266d", "B", "C", "C\u266f/D\u266d", "D", "D\u266f/E\u266d", "E", "F"};

    private HUDHandlerVanilla() {
    }

    @Override
    public xs getStack(IDataAccessor accessor, IPluginConfig config) {
        no block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (block == VanillaPlugin.silverfish && config.get("vanilla.silverfish")) {
            switch (meta) {
                case 1: {
                    return new xs(no.x);
                }
                case 2: {
                    return new xs(no.bn);
                }
            }
            return new xs(no.u);
        }
        if (block == VanillaPlugin.redstone) {
            return new xs(vy.aC);
        }
        if (block instanceof sl) {
            return new xs(no.aO);
        }
        if (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv) {
            return new xs(vy.bb);
        }
        if (block == VanillaPlugin.melonStem) {
            return new xs(vy.bh);
        }
        if (block == VanillaPlugin.pumpkinStem) {
            return new xs(vy.bg);
        }
        if (block == VanillaPlugin.sugarCane) {
            return new xs(vy.aJ);
        }
        if (block == VanillaPlugin.crops) {
            return new xs(vy.T);
        }
        if (block == VanillaPlugin.cauldron) {
            return new xs(vy.bz);
        }
        if (block == VanillaPlugin.bed) {
            return new xs(vy.ba);
        }
        if (block == VanillaPlugin.leave && meta > 3) {
            return new xs(block, 1, meta - 4);
        }
        if (block == VanillaPlugin.log) {
            return new xs(block, 1, meta % 4);
        }
        if (block == VanillaPlugin.sapling || block instanceof aik) {
            return new xs(block, 1, mod_BlockHelper.Accessor.damageDropped(block, meta));
        }
        if (block == VanillaPlugin.brewingStand || block instanceof ng) {
            return new xs(block.a(meta, (Random)ConstantRandom.INSTANCE, 0), 1, mod_BlockHelper.Accessor.damageDropped(block, meta));
        }
        return null;
    }

    @Override
    public void modifyHead(xs itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        no block = accessor.getBlock();
        if (block == VanillaPlugin.mobSpawner && accessor.getTileEntity() instanceof bx && config.get("vanilla.spawntype")) {
            String name = (String)currenttip.get(0);
            String mobname = ((bx)accessor.getTileEntity()).a();
            currenttip.set(0, name + " (" + mobname + ")");
        }
        if (block == VanillaPlugin.melonStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.melonStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.pumpkinStem) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pumpkinStem.name", new Object[0]));
        }
        if (block == VanillaPlugin.endPortal) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.endPortal.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonExtension) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonExtension.name", new Object[0]));
        }
        if (block == VanillaPlugin.pistonMoving) {
            currenttip.set(0, "\u00a7f" + I18n.translate("tile.pistonMoving.name", new Object[0]));
        }
        if (block instanceof aik) {
            currenttip.set(0, "\u00a7f" + DisplayUtil.itemDisplayNameShort(new xs(block.a(accessor.getMetadata(), (Random)ConstantRandom.INSTANCE, 0), 1, mod_BlockHelper.Accessor.damageDropped(block, accessor.getMetadata()))));
        }
        if (block == VanillaPlugin.silverfish && !config.get("vanilla.silverfish")) {
            switch (accessor.getMetadata()) {
                case 1: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.monsterStoneEgg.cobble.name", new Object[0]));
                    break;
                }
                case 2: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.monsterStoneEgg.brick.name", new Object[0]));
                    break;
                }
                default: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.monsterStoneEgg.stone.name", new Object[0]));
                }
            }
        }
        if (block == VanillaPlugin.tallGrass) {
            switch (accessor.getMetadata()) {
                case 0: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.tallgrass.shrub.name", new Object[0]));
                    break;
                }
                case 1: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.tallgrass.grass.name", new Object[0]));
                    break;
                }
                case 2: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.tallgrass.fern.name", new Object[0]));
                    break;
                }
                default: {
                    currenttip.set(0, "\u00a7f" + I18n.translate("tile.tallgrass.name", new Object[0]));
                }
            }
        }
    }

    @Override
    public void modifyBody(xs itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
        no block = accessor.getBlock();
        int meta = accessor.getMetadata();
        if (config.get("vanilla.leverstate") && block == VanillaPlugin.lever) {
            String redstoneOn = (meta & 8) == 0 ? I18n.translate("hud.msg.off", new Object[0]) : I18n.translate("hud.msg.on", new Object[0]);
            currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + redstoneOn);
        }
        if (config.get("vanilla.repeater") && (block == VanillaPlugin.repeaterIdle || block == VanillaPlugin.repeaterActv)) {
            int tick = ((meta & 0xC) >> 2) + 1;
            if (tick == 1) {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": 1 tick");
            } else {
                currenttip.add(I18n.translate("hud.msg.delay", new Object[0]) + ": " + tick + " ticks");
            }
        }
        if (config.get("vanilla.redstone") && block == VanillaPlugin.redstone) {
            currenttip.add(I18n.translate("hud.msg.power", new Object[0]) + ": " + meta);
        }
        if (config.get("vanilla.jukebox") && block == VanillaPlugin.jukebox) {
            aav tag = accessor.getNBTData();
            vy record = null;
            if (tag.c("RecordItem")) {
                xs stack = xs.a((aav)tag.l("RecordItem"));
                vy vy2 = record = stack == null ? null : stack.a();
            }
            if (record == null && tag.c("Record")) {
                record = vy.e[accessor.getNBTInteger(tag, "Record")];
            }
            currenttip.add(record == null ? I18n.translate("hud.msg.empty", new Object[0]) : I18n.translate("hud.msg.record", new Object[0]) + ": " + "C418 - " + ((aet)record).a);
        }
        if (config.get("vanilla.noteblock") && block == VanillaPlugin.noteBlock) {
            int note = accessor.getNBTInteger("note");
            currenttip.add(I18n.translate("hud.msg.note", new Object[0]) + ": " + NOTES[note % 12] + (note / 12 + 1));
            nx mop = accessor.getPosition();
            zo m = accessor.getWorld().f(mop.b, mop.c - 1, mop.d);
            String instrument = "hud.msg.piano";
            if (m == zo.e) {
                instrument = "hud.msg.bass_drum";
            } else if (m == zo.o) {
                instrument = "hud.msg.snare_drum";
            } else if (m == zo.q) {
                instrument = "hud.msg.clicks_sticks";
            } else if (m == zo.d) {
                instrument = "hud.msg.bass_guitar";
            }
            currenttip.add(I18n.translate("hud.msg.instrument", new Object[0]) + ": " + I18n.translate(instrument, new Object[0]));
        }
    }

    @Override
    public void modifyTail(xs itemStack, ITaggedList<String, String> currenttip, IDataAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(js te, aav tag, IServerDataAccessor accessor, IPluginConfig config) {
    }
}

