/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderItem;
import net.minecraft.src.ScaledResolution;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.util.Dimension;

public final class DisplayUtil {
    private static final FontRenderer fontRenderer = ModLoader.getMinecraftInstance().fontRenderer;
    private static final RenderEngine renderEngine = ModLoader.getMinecraftInstance().renderEngine;
    private static final RenderItem renderItem = new RenderItem();

    private DisplayUtil() {
        throw new UnsupportedOperationException();
    }

    public static int getDisplayWidth(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int width = 0;
        Matcher renderMatcher = SpecialChars.patternRender.matcher(s);
        while (renderMatcher.find()) {
            ITooltipRenderer renderer = WailaRegistrar.instance().getTooltipRenderer(renderMatcher.group(1));
            if (renderer == null) continue;
            width += renderer.getSize(renderMatcher.group(2).split(","), DataAccessorCommon.INSTANCE).getWidth();
        }
        Matcher iconMatcher = SpecialChars.patternIcon.matcher(s);
        while (iconMatcher.find()) {
            width += 8;
        }
        return width += fontRenderer.getStringWidth(DisplayUtil.stripSymbols(s));
    }

    public static Dimension displaySize() {
        Minecraft mc = ModLoader.getMinecraftInstance();
        ScaledResolution res = new ScaledResolution(mc.gameSettings, mc.displayWidth, mc.displayHeight);
        return new Dimension(res.getScaledWidth(), res.getScaledHeight());
    }

    public static String stripSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternMinecraft.matcher(result).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static String stripWailaSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static void renderStack(int x, int y, ItemStack stack) {
        if (stack == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glEnable((int)32826);
        GL13.glMultiTexCoord2f((int)33985, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            renderItem.renderItemIntoGUI(fontRenderer, renderEngine, stack, x, y);
            renderItem.renderItemOverlayIntoGUI(fontRenderer, renderEngine, stack, x, y);
        }
        catch (Throwable t) {
            WailaExceptionHandler.handleErr(t, stack.getItem().getClass(), null);
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
    }

    public static void drawGradientRect(int x, int y, int w, int h, int grad1, int grad2) {
        float zLevel = 0.0f;
        float f = (float)(grad1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(grad1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(grad1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(grad1 & 0xFF) / 255.0f;
        float f4 = (float)(grad2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(grad2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(grad2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(grad2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(f1, f2, f3, f);
        tessellator.addVertex((double)(x + w), (double)y, (double)zLevel);
        tessellator.addVertex((double)x, (double)y, (double)zLevel);
        tessellator.setColorRGBA_F(f5, f6, f7, f4);
        tessellator.addVertex((double)x, (double)(y + h), (double)zLevel);
        tessellator.addVertex((double)(x + w), (double)(y + h), (double)zLevel);
        tessellator.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int w, int h, int tw, int th) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        tessellator.addVertexWithUV((double)x, (double)(y + h), (double)zLevel, (double)((float)u * f), (double)((float)(v + th) * f1));
        tessellator.addVertexWithUV((double)(x + w), (double)(y + h), (double)zLevel, (double)((float)(u + tw) * f), (double)((float)(v + th) * f1));
        tessellator.addVertexWithUV((double)(x + w), (double)y, (double)zLevel, (double)((float)(u + tw) * f), (double)((float)v * f1));
        tessellator.addVertexWithUV((double)x, (double)y, (double)zLevel, (double)((float)u * f), (double)((float)v * f1));
        tessellator.draw();
    }

    public static void drawString(String text, int x, int y, int colour, boolean shadow) {
        if (shadow) {
            fontRenderer.drawStringWithShadow(text, x, y, colour);
        } else {
            fontRenderer.drawString(text, x, y, colour);
        }
    }

    public static List<String> itemDisplayNameMultilineUnformatted(ItemStack itemstack) {
        ArrayList<String> namelist = null;
        try {
            namelist = itemstack.func_40712_q();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.isEmpty()) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).isEmpty()) {
            namelist.set(0, "Unnamed");
        }
        return namelist;
    }

    public static String itemDisplayNameShortUnformatted(ItemStack itemstack) {
        return DisplayUtil.itemDisplayNameMultilineUnformatted(itemstack).get(0);
    }

    public static List<String> itemDisplayNameMultiline(ItemStack itemstack) {
        List<String> namelist = DisplayUtil.itemDisplayNameMultilineUnformatted(itemstack);
        namelist.set(0, "\u00a7" + Integer.toHexString(itemstack.func_40707_s().field_40535_e) + namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, "\u00a77" + namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        return DisplayUtil.itemDisplayNameMultiline(itemstack).get(0);
    }

    public static void renderIcon(int x, int y, int sx, int sy, IconUI icon) {
        if (icon == null) {
            return;
        }
        ModLoader.getMinecraftInstance().renderEngine.bindTexture(ModLoader.getMinecraftInstance().renderEngine.getTexture(icon.texture));
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }

    static {
        DisplayUtil.renderItem.field_40268_b = 200.0f;
    }
}

