/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanilla;

import mcp.mobius.waila.addons.vanilla.VanillaPlugin;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerEntityAccessor;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.I18n;
import mcp.mobius.waila.utils.StringUtils;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public final class HUDHandlerEntities
implements IEntityProvider {
    public static final IEntityProvider INSTANCE = new HUDHandlerEntities();
    public static int nhearts = 20;
    public static float maxhpfortext = 40.0f;

    private HUDHandlerEntities() {
    }

    @Override
    public md getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return null;
    }

    @Override
    public xs getDisplayItem(IEntityAccessor accessor, IPluginConfig config) {
        if (accessor.getEntity() instanceof add) {
            return new xs(no.an);
        }
        return null;
    }

    @Override
    public void modifyHead(md entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        if (entity instanceof wd) {
            currenttip.set(0, "\u00a7f" + ((wd)entity).aC);
        }
    }

    @Override
    public void modifyBody(md entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.get("vanilla.showhp") && entity instanceof zs) {
            nhearts = nhearts <= 0 ? 20 : nhearts;
            aav tag = accessor.getNBTData();
            float health = accessor.getNBTInteger(tag, "Health");
            float maxhp = accessor.getNBTInteger(tag, "MaxHealth");
            float healthHearts = health / 2.0f;
            float maxhpHearts = maxhp / 2.0f;
            if (maxhp > maxhpfortext) {
                currenttip.add(String.format("%.0f \u2764 / %.0f \u2764", Float.valueOf(health), Float.valueOf(maxhp)));
            } else {
                currenttip.add(SpecialChars.getRenderString("waila.health", nhearts, Float.valueOf(healthHearts), Float.valueOf(maxhpHearts)));
            }
        }
        if (config.get("vanilla.breed") && entity instanceof av) {
            int age = accessor.getNBTInteger("Age");
            if (age < 0) {
                currenttip.add(I18n.translate("hud.msg.adult_in", new Object[0]) + ": " + I18n.translate("hud.msg.seconds_format", -age / 20));
            } else if (age > 0) {
                currenttip.add(I18n.translate("hud.msg.cooldown", new Object[0]) + ": " + I18n.translate("hud.msg.seconds_format", age / 20));
            } else {
                av animal = (av)entity;
                int inLove = accessor.getNBTInteger("InLove");
                try {
                    if (inLove != 0) {
                        currenttip.add(I18n.translate("hud.msg.in_love", new Object[0]) + ": " + I18n.translate("hud.msg.seconds_format", inLove / 20));
                    } else if (accessor.getPlayer().as() != null && ((Boolean)VanillaPlugin.isWheat.invoke((Object)animal, accessor.getPlayer().as())).booleanValue()) {
                        currenttip.add(I18n.translate("hud.msg.can_be_bred", new Object[0]));
                    }
                }
                catch (Throwable t) {
                    WailaExceptionHandler.handleErr(t, animal.getClass(), currenttip);
                }
            }
        }
        if (config.get("vanilla.tame") && entity instanceof vv) {
            boolean angry;
            boolean isTamed;
            String ownerName = accessor.getNBTData().j("Owner");
            boolean bl = isTamed = ownerName != null && !ownerName.isEmpty();
            if (isTamed) {
                currenttip.add(I18n.translate("hud.msg.owner", new Object[0]) + ": " + ownerName);
                int collarColor = accessor.getNBTInteger("CollarColor");
                currenttip.add(I18n.translate("hud.msg.collar", new Object[0]) + ": " + I18n.color(uf.f((int)collarColor)));
            }
            if (angry = accessor.getNBTData().n("Angry")) {
                currenttip.add(I18n.translate("hud.msg.state", new Object[0]) + ": " + I18n.translate("hud.msg.angry", new Object[0]));
            }
        }
        if (config.get("vanilla.sheep") && entity instanceof ci) {
            currenttip.add(I18n.translate("hud.msg.color", new Object[0]) + ": " + I18n.color(uf.f((int)accessor.getNBTInteger("Color"))));
        }
        if (config.get("vanilla.villager")) {
            int conversionTime;
            if (entity instanceof afs && accessor.getNBTData().n("IsVillager") && (conversionTime = accessor.getNBTInteger("ConversionTime")) > -1) {
                currenttip.add(I18n.translate("hud.msg.converting_to_villager", new Object[0]) + ": " + I18n.translate("hud.msg.seconds_format", conversionTime / 20));
            }
            if (entity instanceof dq) {
                String profession = "hud.msg.villager.modded";
                int professionId = accessor.getNBTInteger("Profession");
                switch (professionId) {
                    case 0: {
                        profession = "hud.msg.villager.farmer";
                        break;
                    }
                    case 1: {
                        profession = "hud.msg.villager.librarian";
                        break;
                    }
                    case 2: {
                        profession = "hud.msg.villager.priest";
                        break;
                    }
                    case 3: {
                        profession = "hud.msg.villager.smith";
                        break;
                    }
                    case 4: {
                        profession = "hud.msg.villager.butcher";
                    }
                }
                currenttip.add(I18n.translate("hud.msg.profession", new Object[0]) + ": " + StringUtils.firstCharacterUppercase(I18n.translate(profession, new Object[0]).replaceFirst("hud\\.msg\\.villager\\.", "")));
            }
        }
        if (config.get("vanilla.tnt") && entity instanceof add) {
            String fuseSeconds = String.format("%.2f", Float.valueOf((float)accessor.getNBTInteger("Fuse") / 20.0f));
            currenttip.add(I18n.translate("hud.msg.fuse", new Object[0]) + ": " + I18n.translate("hud.msg.seconds_format", fuseSeconds));
        }
    }

    @Override
    public void modifyTail(md entity, ITaggedList<String, String> currenttip, IEntityAccessor accessor, IPluginConfig config) {
    }

    @Override
    public void appendServerData(md ent, aav tag, IServerEntityAccessor accessor, IPluginConfig config) {
        if (ent instanceof zs) {
            tag.a("MaxHealth", ((zs)ent).c());
        }
    }
}

